/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.BaseNumberLiaison;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.FloatDefault;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.FloatRange;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class FloatLiaison
extends BaseNumberLiaison<Float, FloatDefault, FloatRange> {
    @Override
    @NonNull Class<Float> boxedType() {
        return Float.class;
    }

    @Override
    @NonNull Class<Float> primitiveType() {
        return Float.TYPE;
    }

    @Override
    @NonNull Class<FloatDefault> defaultAnnotation() {
        return FloatDefault.class;
    }

    @Override
    @NonNull Float defaultValue(@NonNull FloatDefault defaultAnnotation) {
        return Float.valueOf(defaultAnnotation.value());
    }

    @Override
    @NonNull Float ifMissing(@NonNull FloatDefault defaultAnnotation) {
        return Float.valueOf(defaultAnnotation.ifMissing());
    }

    @Override
    @Nullable Float castNumbers(@NonNull Object input) {
        double doubleValue;
        if (input instanceof Float) {
            return Float.valueOf(((Float)input).floatValue());
        }
        if (input instanceof Long) {
            return Float.valueOf(((Long)input).longValue());
        }
        if (input instanceof Integer) {
            return Float.valueOf(((Integer)input).intValue());
        }
        if (input instanceof Short) {
            return Float.valueOf(((Short)input).shortValue());
        }
        if (input instanceof Byte) {
            return Float.valueOf(((Byte)input).byteValue());
        }
        if (input instanceof Double && (doubleValue = ((Double)input).doubleValue()) <= 3.4028234663852886E38 && doubleValue >= -3.4028234663852886E38) {
            return Float.valueOf((float)doubleValue);
        }
        return null;
    }

    @Override
    @Nullable Float parseFrom(@NonNull String input) {
        try {
            return Float.valueOf(Float.parseFloat(input));
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    @Override
    @NonNull Class<FloatRange> rangeAnnotation() {
        return FloatRange.class;
    }

    @Override
    @NonNull Float minFrom(@NonNull FloatRange floatRange) {
        return Float.valueOf(floatRange.min());
    }

    @Override
    @NonNull Float maxFrom(@NonNull FloatRange floatRange) {
        return Float.valueOf(floatRange.max());
    }

    @Override
    boolean isNaN(@NonNull Float value) {
        return value.isNaN();
    }

    @Override
    boolean greaterOrEq(@NonNull Float value, @NonNull Float min) {
        return min.floatValue() == Float.NEGATIVE_INFINITY || value.floatValue() >= min.floatValue();
    }

    @Override
    boolean lessOrEq(@NonNull Float value, @NonNull Float max) {
        return max.floatValue() == Float.POSITIVE_INFINITY || value.floatValue() <= max.floatValue();
    }
}

