/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ErrorContext;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.LoadResult;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.Printable;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.DeserializeInput;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.SerializeDeserialize;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.SerializeOutput;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.TypeLiaison;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.internals.lang.LibraryLang;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.TypeToken;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class EnumLiaison
implements TypeLiaison {
    @Override
    @SideEffectFree
    public <V> @Nullable TypeLiaison.Agent<V> makeAgent(@NonNull TypeToken<V> typeToken, @NonNull TypeLiaison.Handshake handshake) {
        Class<V> rawType = typeToken.getRawType();
        if (rawType.isEnum()) {
            AgentImpl<Enum> castAgent = new AgentImpl<Enum>(rawType.asSubclass(Enum.class));
            return castAgent;
        }
        return null;
    }

    private static final class AgentImpl<E extends Enum<E>>
    implements TypeLiaison.Agent<E> {
        private final E[] enumConstants;

        AgentImpl(Class<E> enumClass) {
            this.enumConstants = (Enum[])enumClass.getEnumConstants();
        }

        @Override
        @SideEffectFree
        public @NonNull SerializeDeserialize<E> makeSerializer() {
            return new SerializeDeserialize<E>(){

                @Override
                public @NonNull LoadResult<@NonNull E> deserialize(@NonNull DeserializeInput deser) {
                    Object object = deser.object();
                    if (object instanceof String) {
                        String string = (String)object;
                        for (Enum enumVal : enumConstants) {
                            if (!enumVal.name().equalsIgnoreCase(string)) continue;
                            return LoadResult.of(enumVal);
                        }
                    }
                    LibraryLang libraryLang = LibraryLang.Accessor.access(deser, ErrorContext.Source::getLocale);
                    int numberAccepted = enumConstants.length;
                    int exampleCount = Math.min(numberAccepted, 4);
                    boolean capped = exampleCount < numberAccepted;
                    String[] acceptedExamples = new String[capped ? exampleCount + 1 : exampleCount];
                    for (int n = 0; n < exampleCount; ++n) {
                        acceptedExamples[n] = enumConstants[n].name();
                    }
                    if (capped) {
                        acceptedExamples[exampleCount] = '+' + libraryLang.more(numberAccepted - exampleCount);
                    }
                    return deser.throwError(Printable.join(Printable.preBuilt(libraryLang.badValue()), Printable.preBuilt(" "), libraryLang.notAccepted(object.toString(), acceptedExamples)));
                }

                @Override
                public void serialize(@NonNull E value, @NonNull SerializeOutput ser) {
                    ser.outString(((Enum)value).name());
                }
            };
        }
    }
}

