/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.BaseNumberLiaison;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.DoubleDefault;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.DoubleRange;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class DoubleLiaison
extends BaseNumberLiaison<Double, DoubleDefault, DoubleRange> {
    @Override
    @NonNull Class<Double> boxedType() {
        return Double.class;
    }

    @Override
    @NonNull Class<Double> primitiveType() {
        return Double.TYPE;
    }

    @Override
    @NonNull Class<DoubleDefault> defaultAnnotation() {
        return DoubleDefault.class;
    }

    @Override
    @NonNull Double defaultValue(@NonNull DoubleDefault defaultAnnotation) {
        return defaultAnnotation.value();
    }

    @Override
    @NonNull Double ifMissing(@NonNull DoubleDefault defaultAnnotation) {
        return defaultAnnotation.ifMissing();
    }

    @Override
    @Nullable Double castNumbers(@NonNull Object input) {
        if (input instanceof Double) {
            return (double)((Double)input);
        }
        if (input instanceof Float) {
            return ((Float)input).floatValue();
        }
        if (input instanceof Long) {
            return (double)((Long)input);
        }
        if (input instanceof Integer) {
            return (double)((Integer)input);
        }
        if (input instanceof Short) {
            return (double)((Short)input);
        }
        if (input instanceof Byte) {
            return (double)((Byte)input);
        }
        return null;
    }

    @Override
    @Nullable Double parseFrom(@NonNull String input) {
        try {
            return Double.parseDouble(input);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    @Override
    @NonNull Class<DoubleRange> rangeAnnotation() {
        return DoubleRange.class;
    }

    @Override
    @NonNull Double minFrom(@NonNull DoubleRange doubleRange) {
        return doubleRange.min();
    }

    @Override
    @NonNull Double maxFrom(@NonNull DoubleRange doubleRange) {
        return doubleRange.max();
    }

    @Override
    boolean isNaN(@NonNull Double value) {
        return value.isNaN();
    }

    @Override
    boolean greaterOrEq(@NonNull Double value, @NonNull Double min) {
        return min == Double.NEGATIVE_INFINITY || value >= min;
    }

    @Override
    boolean lessOrEq(@NonNull Double value, @NonNull Double max) {
        return max == Double.POSITIVE_INFINITY || value <= max;
    }
}

