/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.DeveloperMistakeException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ErrorContext;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.LoadResult;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataEntry;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataList;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.KeyPath;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.DeserializeInput;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.SerializeDeserialize;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.SerializeOutput;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.TypeLiaison;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.UpdateReason;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.internals.ImmutableCollections;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.TypeToken;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class CollectionLiaison
implements TypeLiaison {
    @Override
    @SideEffectFree
    public <V> @Nullable TypeLiaison.Agent<V> makeAgent(@NonNull TypeToken<V> typeToken, @NonNull TypeLiaison.Handshake handshake) {
        TypeLiaison.Agent casted = this.makeAgent(typeToken.getRawType(), () -> {
            TypeToken elementToken = new TypeToken(typeToken.getReifiedType().argumentAt(0));
            return handshake.getOtherSerializer(elementToken);
        });
        return casted;
    }

    private <E> TypeLiaison.Agent<? extends Collection<E>> makeAgent(Class<?> rawType, Supplier<SerializeDeserialize<E>> elementSerializer) {
        if (rawType.equals(List.class)) {
            return new ListAgent(elementSerializer.get());
        }
        if (rawType.equals(Set.class)) {
            return new SetAgent(elementSerializer.get());
        }
        if (rawType.equals(Collection.class)) {
            return new CollectionAgent(elementSerializer.get());
        }
        return null;
    }

    private static final class ListAgent<E>
    extends AgentBase<List<E>, E, Object[]> {
        private ListAgent(SerializeDeserialize<E> elementSerializer) {
            super(elementSerializer);
        }

        @Override
        Object @NonNull [] makeMutableOutput(int sizeHint) {
            return new Object[sizeHint];
        }

        @Override
        void addToMutableOutput(Object @NonNull [] output, int index, @NonNull E value) {
            output[index] = value;
        }

        @Override
        @NonNull List<E> buildThenCast(Object @NonNull [] output) {
            return ImmutableCollections.listOf(output);
        }
    }

    private static final class SetAgent<E>
    extends AgentBase<Set<E>, E, LinkedHashSet<E>> {
        private SetAgent(SerializeDeserialize<E> elementSerializer) {
            super(elementSerializer);
        }

        @Override
        @NonNull LinkedHashSet<E> makeMutableOutput(int sizeHint) {
            return new LinkedHashSet(sizeHint + 1, 0.999999f);
        }

        @Override
        void addToMutableOutput(@NonNull LinkedHashSet<E> output, int index, @NonNull E value) {
            output.add(value);
        }

        @Override
        @NonNull Set<E> buildThenCast(@NonNull LinkedHashSet<E> output) {
            if (output.isEmpty()) {
                return ImmutableCollections.emptySet();
            }
            return Collections.unmodifiableSet(output);
        }
    }

    private static final class CollectionAgent<E>
    extends AgentBase<Collection<E>, E, Object[]> {
        private CollectionAgent(SerializeDeserialize<E> elementSerializer) {
            super(elementSerializer);
        }

        @Override
        Object @NonNull [] makeMutableOutput(int sizeHint) {
            return new Object[sizeHint];
        }

        @Override
        void addToMutableOutput(Object @NonNull [] output, int index, @NonNull E value) {
            output[index] = value;
        }

        @Override
        @NonNull Collection<E> buildThenCast(Object @NonNull [] output) {
            return ImmutableCollections.listOf(output);
        }
    }

    private static abstract class AgentBase<COLL extends Collection<E>, E, BUILD_COLL>
    implements TypeLiaison.Agent<COLL>,
    SerializeDeserialize<COLL> {
        private final SerializeDeserialize<E> elementSerializer;

        private AgentBase(SerializeDeserialize<E> elementSerializer) {
            this.elementSerializer = elementSerializer;
        }

        @Override
        @SideEffectFree
        public @NonNull SerializeDeserialize<COLL> makeSerializer() {
            return this;
        }

        abstract @NonNull BUILD_COLL makeMutableOutput(int var1);

        abstract void addToMutableOutput(@NonNull BUILD_COLL var1, int var2, @NonNull E var3);

        abstract @NonNull COLL buildThenCast(@NonNull BUILD_COLL var1);

        private <D extends DataList> @NonNull LoadResult<@NonNull COLL> implDeserialize(@NonNull DeserializeInput deser, @NonNull ImplDeserialize<COLL, D, E> impl) {
            LoadResult<DataList> dataListResult = deser.requireDataList();
            if (dataListResult.isFailure()) {
                return LoadResult.failure(dataListResult.getErrorContexts());
            }
            D input = impl.prepare(dataListResult.getOrThrow());
            BUILD_COLL output = this.makeMutableOutput(((DataList)input).size());
            ErrorContext[] collectedErrors = null;
            int errorCount = 0;
            for (int n = 0; n < ((DataList)input).size(); ++n) {
                DataEntry inputEntry = ((DataList)input).get(n);
                LoadResult<E> elemResult = impl.deserialize(this.elementSerializer, deser.makeChild(inputEntry, n));
                if (elemResult.isFailure()) {
                    if (collectedErrors == null) {
                        collectedErrors = new ErrorContext[deser.maximumErrorCollect()];
                    }
                    for (ErrorContext errorToAppend : elemResult.getErrorContexts()) {
                        collectedErrors[errorCount++] = errorToAppend;
                        if (errorCount != collectedErrors.length) continue;
                        return LoadResult.failure(collectedErrors);
                    }
                    continue;
                }
                if (collectedErrors != null) continue;
                impl.updateIfDesired(input, inputEntry, n);
                this.addToMutableOutput(output, n, elemResult.getOrThrow());
            }
            if (collectedErrors != null) {
                return LoadResult.failure((ErrorContext[])Arrays.copyOf(collectedErrors, errorCount));
            }
            COLL built = this.buildThenCast(output);
            if (built.size() != ((DataList)input).size()) {
                impl.updateSizeShrunk(deser, built);
            } else {
                impl.updateMaybeOtherwise(deser, input);
            }
            return LoadResult.of(built);
        }

        @Override
        public @NonNull LoadResult<@NonNull COLL> deserialize(@NonNull DeserializeInput deser) {
            return this.implDeserialize(deser, new ImplDeserialize<COLL, DataList, E>(){

                @Override
                public DataList prepare(DataList dataList) {
                    return dataList;
                }

                @Override
                public LoadResult<E> deserialize(SerializeDeserialize<E> elementSerializer, DeserializeInput deser) {
                    return elementSerializer.deserialize(deser);
                }

                @Override
                public void updateIfDesired(DataList updatableInput, DataEntry existingEntry, int idx) {
                }

                @Override
                public void updateSizeShrunk(DeserializeInput deser, COLL built) {
                    deser.notifyUpdate(KeyPath.empty(), UpdateReason.OTHER);
                }

                @Override
                public void updateMaybeOtherwise(DeserializeInput deser, DataList updatableInput) {
                }
            });
        }

        @Override
        public @NonNull LoadResult<@NonNull COLL> deserializeUpdate(@NonNull DeserializeInput deser, final @NonNull SerializeOutput updateTo) {
            return this.implDeserialize(deser, new ImplDeserialize<COLL, DataList.Mut, E>(){
                private boolean updated;

                @Override
                public DataList.Mut prepare(DataList dataList) {
                    return dataList.intoMut();
                }

                @Override
                public LoadResult<E> deserialize(SerializeDeserialize<E> elementSerializer, DeserializeInput deser) {
                    return elementSerializer.deserializeUpdate(deser, updateTo);
                }

                @Override
                public void updateIfDesired(DataList.Mut updatableInput, DataEntry existingEntry, int idx) {
                    Object elemUpdate = updateTo.getAndClearLastOutput();
                    if (elemUpdate != null && !existingEntry.getValue().equals(elemUpdate)) {
                        updatableInput.set(idx, existingEntry.withValue(elemUpdate));
                        this.updated = true;
                    }
                }

                @Override
                public void updateSizeShrunk(DeserializeInput deser, COLL built) {
                    deser.notifyUpdate(KeyPath.empty(), UpdateReason.OTHER);
                    this.serialize(built, updateTo);
                }

                @Override
                public void updateMaybeOtherwise(DeserializeInput deser, DataList.Mut updatableInput) {
                    if (this.updated) {
                        deser.notifyUpdate(KeyPath.empty(), UpdateReason.UPDATED);
                        updateTo.outDataList(updatableInput);
                    }
                }
            });
        }

        @Override
        public void serialize(@NonNull COLL value, @NonNull SerializeOutput ser) {
            DataList.Mut output = new DataList.Mut(value.size());
            for (Object elem : value) {
                this.elementSerializer.serialize(elem, ser);
                Object elemOutput = ser.getAndClearLastOutput();
                if (elemOutput == null) {
                    throw new DeveloperMistakeException("Element serializer " + this.elementSerializer + " did not produce output");
                }
                output.add(new DataEntry(elemOutput));
            }
            ser.outDataList(output);
        }

        static interface ImplDeserialize<COLL extends Collection<E>, D extends DataList, E> {
            public D prepare(DataList var1);

            public LoadResult<E> deserialize(SerializeDeserialize<E> var1, DeserializeInput var2);

            public void updateIfDesired(D var1, DataEntry var2, int var3);

            public void updateSizeShrunk(DeserializeInput var1, COLL var2);

            public void updateMaybeOtherwise(DeserializeInput var1, D var2);
        }
    }
}

