/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ErrorContext;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.LoadResult;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.Printable;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.DeserializeInput;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.SerializeDeserialize;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.SerializeOutput;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.TypeLiaison;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.internals.lang.LibraryLang;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.reflect.TypeToken;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class CharacterLiaison
implements TypeLiaison {
    @Override
    @SideEffectFree
    public <V> @Nullable TypeLiaison.Agent<V> makeAgent(@NonNull TypeToken<V> typeToken, @NonNull TypeLiaison.Handshake handshake) {
        Class<V> rawType = typeToken.getRawType();
        if (rawType.equals(Character.TYPE) || rawType.equals(Character.class)) {
            AgentImpl castAgent = new AgentImpl();
            return castAgent;
        }
        return null;
    }

    private static final class AgentImpl
    implements TypeLiaison.Agent<Character> {
        private AgentImpl() {
        }

        @Override
        @SideEffectFree
        public @NonNull SerializeDeserialize<Character> makeSerializer() {
            return new SerializeDeserialize<Character>(){

                @Override
                public @NonNull LoadResult<@NonNull Character> deserialize(@NonNull DeserializeInput deser) {
                    Object object = deser.object();
                    if (object instanceof Character) {
                        return LoadResult.of((Character)object);
                    }
                    if (object instanceof String) {
                        String string = (String)object;
                        char[] chars = string.toCharArray();
                        if (chars.length != 1) {
                            LibraryLang libraryLang = LibraryLang.Accessor.access(deser, ErrorContext.Source::getLocale);
                            return deser.throwError(Printable.join(Printable.preBuilt(libraryLang.badValue()), Printable.preBuilt(" "), libraryLang.wrongTypeForValue(object, libraryLang.character(), libraryLang.text())));
                        }
                        return LoadResult.of(Character.valueOf(chars[0]));
                    }
                    LibraryLang libraryLang = LibraryLang.Accessor.access(deser, ErrorContext.Source::getLocale);
                    return deser.throwError(libraryLang.wrongTypeForValue(object, Character.class));
                }

                @Override
                public @NonNull LoadResult<@NonNull Character> deserializeUpdate(@NonNull DeserializeInput deser, @NonNull SerializeOutput updateTo) {
                    Character updated;
                    LoadResult<Character> loadResult = this.deserialize(deser);
                    if (loadResult.isSuccess() && (updated = loadResult.getOrThrow()) != deser.object()) {
                        updateTo.outChar(updated.charValue());
                    }
                    return loadResult;
                }

                @Override
                public void serialize(@NonNull Character value, @NonNull SerializeOutput ser) {
                    ser.outChar(value.charValue());
                }
            };
        }
    }
}

