/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.table;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.TomlValue;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.table.TomlTableLeaf;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.table.TomlTableNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
final class TomlTableBranch
implements TomlTableNode {
    private final Set<TomlTableBranch> parents = Collections.newSetFromMap(new WeakHashMap());
    private int capacity;
    private int len;
    private String[] labels;
    private TomlTableNode[] nodes;
    private int entryCount;
    TomlValue attachedValue;

    @Contract(value="_ -> new")
    @NotNull
    public static TomlTableBranch copyOf(@NotNull TomlTableBranch branch) {
        return TomlTableBranch.copyOf(branch, null);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    private static TomlTableBranch copyOf(@NotNull TomlTableBranch branch, @Nullable TomlTableBranch parent) {
        TomlTableBranch ret = new TomlTableBranch(branch.capacity);
        ret.len = branch.len;
        ret.entryCount = branch.entryCount;
        System.arraycopy(branch.labels, 0, ret.labels, 0, branch.len);
        for (int i = 0; i < branch.len; ++i) {
            TomlTableNode next = branch.nodes[i];
            if (next.isBranch()) {
                next = TomlTableBranch.copyOf(next.asBranch(), ret);
            } else {
                TomlValue tv = next.asLeaf().value();
                next = new TomlTableLeaf(TomlValue.copyOf(tv));
            }
            ret.nodes[i] = next;
        }
        if (parent != null) {
            ret.parents.add(parent);
        }
        return ret;
    }

    private TomlTableBranch(int capacity) {
        this.capacity = capacity;
        this.len = 0;
        this.labels = new String[capacity];
        this.nodes = new TomlTableNode[capacity];
        this.entryCount = 0;
        this.attachedValue = null;
    }

    TomlTableBranch() {
        this(8);
    }

    @NotNull
    public @Unmodifiable List<String> keys() {
        return Collections.unmodifiableList(Arrays.asList(this.labels).subList(0, this.len));
    }

    public int keyCount() {
        return this.len;
    }

    public void clear() {
        this.len = 0;
        if (this.capacity > 8) {
            this.resize(8);
        }
        this.modifyEntryCount(-this.entryCount);
    }

    @Nullable
    public TomlTableNode get(@NotNull String label) {
        for (int i = 0; i < this.len; ++i) {
            TomlTableNode next = this.nodes[i];
            int cmp = label.compareTo(this.labels[i]);
            if (cmp < 0) break;
            if (cmp != 0) continue;
            return next;
        }
        return null;
    }

    @Nullable
    public TomlTableNode put(@NotNull String label, @NotNull TomlTableNode node) {
        int idx = this.len;
        boolean shift = false;
        if (node.isBranch()) {
            node.asBranch().addParent(this);
        }
        for (int i = 0; i < this.len; ++i) {
            TomlTableNode next = this.nodes[i];
            int cmp = label.compareTo(this.labels[i]);
            if (cmp == 0) {
                this.nodes[i] = node;
                this.modifyEntryCount(node.entryCount() - next.entryCount());
                return next;
            }
            if (cmp >= 0) continue;
            idx = i;
            shift = true;
            break;
        }
        this.ensureSpace();
        if (shift) {
            System.arraycopy(this.nodes, idx, this.nodes, idx + 1, this.len - idx);
            System.arraycopy(this.labels, idx, this.labels, idx + 1, this.len - idx);
        }
        this.nodes[idx] = node;
        this.labels[idx] = label;
        ++this.len;
        this.modifyEntryCount(node.entryCount());
        return null;
    }

    @Nullable
    public TomlTableNode remove(@NotNull String label) {
        for (int i = 0; i < this.len; ++i) {
            TomlTableNode next = this.nodes[i];
            int cmp = label.compareTo(this.labels[i]);
            if (cmp != 0) {
                if (cmp <= 0) continue;
                break;
            }
            if (next.isBranch()) {
                next.asBranch().removeParent(this);
            }
            --this.len;
            this.modifyEntryCount(-next.entryCount());
            System.arraycopy(this.nodes, i + 1, this.nodes, i, this.len - i);
            System.arraycopy(this.labels, i + 1, this.labels, i, this.len - i);
            this.tryShrink();
            return next;
        }
        return null;
    }

    private void modifyEntryCount(int mod) {
        this.entryCount += mod;
        for (TomlTableBranch parent : this.parents) {
            parent.modifyEntryCount(mod);
        }
    }

    private boolean isInHierarchy(@NotNull TomlTableBranch subject) {
        if (this.equals(subject)) {
            return true;
        }
        for (TomlTableBranch parent : this.parents) {
            if (!parent.isInHierarchy(subject)) continue;
            return true;
        }
        return false;
    }

    private void addParent(@NotNull TomlTableBranch parent) {
        if (parent.isInHierarchy(this)) {
            throw new IllegalStateException("Attempt to create circular table relationship");
        }
        this.parents.add(parent);
    }

    private void removeParent(@NotNull TomlTableBranch parent) {
        this.parents.remove(parent);
    }

    private void resize(int tc) {
        TomlTableNode[] nn = new TomlTableNode[tc];
        System.arraycopy(this.nodes, 0, nn, 0, this.len);
        String[] nl = new String[tc];
        System.arraycopy(this.labels, 0, nl, 0, this.len);
        this.capacity = tc;
        this.nodes = nn;
        this.labels = nl;
    }

    private void ensureSpace() {
        if (this.len < this.capacity) {
            return;
        }
        this.resize(this.capacity << 1);
    }

    private void tryShrink() {
        int tc = this.capacity >> 1;
        if (this.len > tc) {
            return;
        }
        this.resize(tc);
    }

    @Override
    public int entryCount() {
        return this.entryCount;
    }

    @Override
    public boolean isBranch() {
        return true;
    }

    @Override
    @Contract(value="-> this")
    @NotNull
    public TomlTableBranch asBranch() {
        return this;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    @Contract(value="-> fail")
    @NotNull
    public TomlTableLeaf asLeaf() {
        throw new UnsupportedOperationException();
    }
}

