/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.table;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.key.TomlKey;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.TomlValue;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive.TomlPrimitive;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.table.TomlTableImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.NonExtendable
public interface TomlTable
extends TomlValue {
    @Contract(value="-> new")
    @NotNull
    public static TomlTable create() {
        return new TomlTableImpl();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static TomlTable copyOf(@NotNull TomlTable other) {
        return TomlTableImpl.copyOf((TomlTableImpl)other);
    }

    @Contract(pure=true)
    public int size();

    public boolean isEmpty();

    public void clear();

    @NotNull
    public @Unmodifiable Set<TomlKey> keys(boolean var1);

    @NotNull
    default public @Unmodifiable Set<TomlKey> keys() {
        return this.keys(true);
    }

    public boolean contains(@NotNull TomlKey var1);

    default public boolean contains(@NotNull CharSequence key) {
        return this.contains(TomlKey.parse(key));
    }

    @Nullable
    public TomlValue get(@NotNull TomlKey var1);

    @Nullable
    default public TomlValue get(@NotNull CharSequence key) {
        return this.get(TomlKey.parse(key));
    }

    @Nullable
    public TomlValue put(@NotNull TomlKey var1, @NotNull TomlValue var2);

    @Nullable
    default public TomlValue put(@NotNull CharSequence key, @NotNull TomlValue value) {
        return this.put(TomlKey.parse(key), value);
    }

    @Nullable
    default public TomlValue put(@NotNull TomlKey key, @NotNull String value) {
        return this.put(key, (TomlValue)TomlPrimitive.of(value));
    }

    @Nullable
    default public TomlValue put(@NotNull TomlKey key, boolean value) {
        return this.put(key, (TomlValue)TomlPrimitive.of(value));
    }

    @Nullable
    default public TomlValue put(@NotNull TomlKey key, long value) {
        return this.put(key, (TomlValue)TomlPrimitive.of(value));
    }

    @Nullable
    default public TomlValue put(@NotNull TomlKey key, int value) {
        return this.put(key, (TomlValue)TomlPrimitive.of(value));
    }

    @Nullable
    default public TomlValue put(@NotNull TomlKey key, double value) {
        return this.put(key, (TomlValue)TomlPrimitive.of(value));
    }

    @Nullable
    default public TomlValue put(@NotNull TomlKey key, float value) {
        return this.put(key, (TomlValue)TomlPrimitive.of(value));
    }

    @Nullable
    default public TomlValue put(@NotNull CharSequence key, @NotNull String value) {
        return this.put(key, (TomlValue)TomlPrimitive.of(value));
    }

    @Nullable
    default public TomlValue put(@NotNull CharSequence key, boolean value) {
        return this.put(key, (TomlValue)TomlPrimitive.of(value));
    }

    @Nullable
    default public TomlValue put(@NotNull CharSequence key, long value) {
        return this.put(key, (TomlValue)TomlPrimitive.of(value));
    }

    @Nullable
    default public TomlValue put(@NotNull CharSequence key, int value) {
        return this.put(key, (TomlValue)TomlPrimitive.of(value));
    }

    @Nullable
    default public TomlValue put(@NotNull CharSequence key, double value) {
        return this.put(key, (TomlValue)TomlPrimitive.of(value));
    }

    @Nullable
    default public TomlValue put(@NotNull CharSequence key, float value) {
        return this.put(key, (TomlValue)TomlPrimitive.of(value));
    }

    @Nullable
    public TomlValue remove(@NotNull TomlKey var1);

    @Nullable
    default public TomlValue remove(@NotNull String key) {
        return this.remove(TomlKey.parse(key));
    }

    @Contract(value="-> new")
    @NotNull
    default public Map<TomlKey, TomlValue> toMap() {
        Set<TomlKey> keys = this.keys();
        HashMap<TomlKey, TomlValue> map = new HashMap<TomlKey, TomlValue>(keys.size());
        for (TomlKey key : keys) {
            map.put(key, this.get(key));
        }
        return map;
    }
}

