/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.comment.Comments;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.except.TomlValueException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.TomlValue;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive.AbstractTomlPrimitive;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive.BooleanTomlPrimitive;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive.FloatTomlPrimitive;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive.IntegerTomlPrimitive;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive.LocalDateTimeTomlPrimitive;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive.LocalDateTomlPrimitive;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive.LocalTimeTomlPrimitive;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive.OffsetDateTimeTomlPrimitive;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive.StringTomlPrimitive;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive.TomlPrimitiveType;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public interface TomlPrimitive
extends TomlValue {
    @Contract(value="null -> fail; !null -> new")
    @NotNull
    public static TomlPrimitive of(String value) {
        return new StringTomlPrimitive(Objects.requireNonNull(value));
    }

    @Contract(value="_ -> new")
    @NotNull
    public static TomlPrimitive of(boolean value) {
        return new BooleanTomlPrimitive(value);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static TomlPrimitive of(long value) {
        return new IntegerTomlPrimitive(value);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static TomlPrimitive of(int value) {
        return TomlPrimitive.of((long)value);
    }

    @NotNull
    public static TomlPrimitive of(double value) {
        return new FloatTomlPrimitive(value);
    }

    @NotNull
    public static TomlPrimitive of(float value) {
        return TomlPrimitive.of((double)value);
    }

    @Contract(value="null -> fail; !null -> new")
    @NotNull
    public static TomlPrimitive of(OffsetDateTime value) throws TomlValueException {
        return new OffsetDateTimeTomlPrimitive(Objects.requireNonNull(value));
    }

    @Contract(value="null, _ -> fail; !null, _ -> new")
    @NotNull
    public static TomlPrimitive of(LocalDateTime value, @Nullable ZoneOffset offset) throws TomlValueException {
        return new LocalDateTimeTomlPrimitive(Objects.requireNonNull(value), offset == null ? ZoneOffset.UTC : offset);
    }

    @Contract(value="null -> fail; !null -> new")
    @NotNull
    public static TomlPrimitive of(LocalDateTime value) throws TomlValueException {
        return TomlPrimitive.of(value, null);
    }

    @Contract(value="null, _ -> fail; !null, _ -> new")
    @NotNull
    public static TomlPrimitive of(LocalDate value, @Nullable ZoneOffset offset) throws TomlValueException {
        return new LocalDateTomlPrimitive(Objects.requireNonNull(value), offset == null ? ZoneOffset.UTC : offset);
    }

    @Contract(value="null -> fail; !null -> new")
    @NotNull
    public static TomlPrimitive of(LocalDate value) throws TomlValueException {
        return TomlPrimitive.of(value, null);
    }

    @Contract(value="null, _ -> fail; !null, _ -> new")
    @NotNull
    public static TomlPrimitive of(LocalTime value, @Nullable ZoneOffset offset) {
        return new LocalTimeTomlPrimitive(Objects.requireNonNull(value), offset == null ? ZoneOffset.UTC : offset);
    }

    @Contract(value="null -> fail; !null -> new")
    @NotNull
    public static TomlPrimitive of(LocalTime value) {
        return TomlPrimitive.of(value, null);
    }

    @Contract(value="_ -> new")
    @ApiStatus.AvailableSince(value="0.6.4")
    @NotNull
    public static TomlPrimitive copyOf(@NotNull TomlPrimitive other) {
        Comments comments = Comments.copyOf(other.comments());
        switch (other.type()) {
            case BOOLEAN: {
                return new BooleanTomlPrimitive(comments, other.asBoolean());
            }
            case FLOAT: {
                return new FloatTomlPrimitive(comments, other.asDouble());
            }
            case INTEGER: {
                return new IntegerTomlPrimitive(comments, other.asLong());
            }
            case STRING: {
                return new StringTomlPrimitive(comments, other.asString());
            }
            case OFFSET_DATE_TIME: {
                return new OffsetDateTimeTomlPrimitive(comments, other.asOffsetDateTime());
            }
            case LOCAL_DATE_TIME: {
                return new LocalDateTimeTomlPrimitive(comments, other.asLocalDateTime(), ((AbstractTomlPrimitive)other).temporalOffset());
            }
            case LOCAL_DATE: {
                return new LocalDateTomlPrimitive(comments, other.asLocalDate(), ((AbstractTomlPrimitive)other).temporalOffset());
            }
            case LOCAL_TIME: {
                return new LocalTimeTomlPrimitive(comments, other.asLocalTime(), ((AbstractTomlPrimitive)other).temporalOffset());
            }
        }
        throw new AssertionError((Object)"Unreachable code");
    }

    @NotNull
    public TomlPrimitiveType type();

    @NotNull
    public Serializable value();

    default public boolean isString() {
        return this.type() == TomlPrimitiveType.STRING;
    }

    @NotNull
    public String asString();

    default public boolean isBoolean() {
        return this.type() == TomlPrimitiveType.BOOLEAN;
    }

    public boolean asBoolean();

    default public boolean isInteger() {
        return this.type() == TomlPrimitiveType.INTEGER;
    }

    default public int asInteger() throws ArithmeticException {
        return Math.toIntExact(this.asLong());
    }

    public long asLong();

    default public boolean isFloat() {
        return this.type() == TomlPrimitiveType.FLOAT;
    }

    default public float asFloat() {
        return (float)this.asDouble();
    }

    public double asDouble();

    default public boolean isOffsetDateTime() {
        return this.type() == TomlPrimitiveType.OFFSET_DATE_TIME;
    }

    @NotNull
    default public Instant asInstant() {
        return this.asOffsetDateTime().toInstant();
    }

    @NotNull
    default public Date asDate() {
        return Date.from(this.asInstant());
    }

    @NotNull
    default public OffsetDateTime asOffsetDateTime() {
        throw new UnsupportedOperationException();
    }

    default public boolean isLocalDateTime() {
        return this.type() == TomlPrimitiveType.LOCAL_DATE_TIME;
    }

    @NotNull
    default public LocalDateTime asLocalDateTime() {
        throw new UnsupportedOperationException();
    }

    default public boolean isLocalDate() {
        return this.type() == TomlPrimitiveType.LOCAL_DATE;
    }

    @NotNull
    default public LocalDate asLocalDate() {
        throw new UnsupportedOperationException();
    }

    default public boolean isLocalTime() {
        return this.type() == TomlPrimitiveType.LOCAL_TIME;
    }

    @NotNull
    default public LocalTime asLocalTime() {
        throw new UnsupportedOperationException();
    }
}

