/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.comment.Comments;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.except.TomlValueException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive.AbstractTomlPrimitive;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive.TomlPrimitiveType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
final class OffsetDateTimeTomlPrimitive
extends AbstractTomlPrimitive<OffsetDateTime> {
    private final OffsetDateTime value;

    public OffsetDateTimeTomlPrimitive(@NotNull Comments comments, @NotNull OffsetDateTime value) {
        super(comments);
        TomlValueException.checkDate(value);
        this.value = value;
    }

    public OffsetDateTimeTomlPrimitive(@NotNull OffsetDateTime value) {
        this(Comments.empty(), value);
    }

    @Override
    @NotNull
    public TomlPrimitiveType type() {
        return TomlPrimitiveType.OFFSET_DATE_TIME;
    }

    @Override
    @NotNull
    public OffsetDateTime value() {
        return this.value;
    }

    @Override
    @NotNull
    public String asString() {
        StringBuilder sb = new StringBuilder();
        OffsetDateTimeTomlPrimitive.writeDate(sb, this.value.toLocalDate());
        sb.append('T');
        OffsetDateTimeTomlPrimitive.writeTime(sb, this.value.toLocalTime());
        int sec = this.value.getOffset().getTotalSeconds();
        if (sec == 0) {
            sb.append('Z');
            return sb.toString();
        }
        if (sec < 0) {
            sec = -sec;
            sb.append('-');
        } else {
            sb.append('+');
        }
        int hour = sec / 3600;
        int minute = sec % 3600 / 60;
        OffsetDateTimeTomlPrimitive.writeHourMinute(sb, hour, minute);
        return sb.toString();
    }

    @Override
    public boolean asBoolean() {
        return true;
    }

    @Override
    public long asLong() {
        return this.value.toInstant().toEpochMilli();
    }

    @Override
    public double asDouble() {
        return this.asLong();
    }

    @Override
    @NotNull
    public OffsetDateTime asOffsetDateTime() {
        return this.value;
    }

    @Override
    @NotNull
    public LocalDateTime asLocalDateTime() {
        return this.value.toLocalDateTime();
    }

    @Override
    @NotNull
    public LocalDate asLocalDate() {
        return this.asLocalDateTime().toLocalDate();
    }

    @Override
    @NotNull
    public LocalTime asLocalTime() {
        return this.asLocalDateTime().toLocalTime();
    }
}

