/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.comment.Comments;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive.AbstractTomlPrimitive;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive.TomlPrimitiveType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
final class LocalTimeTomlPrimitive
extends AbstractTomlPrimitive<LocalTime> {
    private final LocalTime value;
    private final ZoneOffset offset;

    public LocalTimeTomlPrimitive(@NotNull Comments comments, @NotNull LocalTime value, @NotNull ZoneOffset offset) {
        super(comments);
        this.value = value;
        this.offset = offset;
    }

    public LocalTimeTomlPrimitive(@NotNull LocalTime value, @NotNull ZoneOffset offset) {
        this(Comments.empty(), value, offset);
    }

    @Override
    @NotNull
    public TomlPrimitiveType type() {
        return TomlPrimitiveType.LOCAL_TIME;
    }

    @Override
    @NotNull
    public LocalTime value() {
        return this.value;
    }

    @Override
    @NotNull
    ZoneOffset temporalOffset() {
        return this.offset;
    }

    @Override
    @NotNull
    public String asString() {
        StringBuilder sb = new StringBuilder();
        LocalTimeTomlPrimitive.writeTime(sb, this.value);
        return sb.toString();
    }

    @Override
    public boolean asBoolean() {
        return true;
    }

    @Override
    public long asLong() {
        return this.value.atDate(LocalDate.now()).toInstant(ZoneOffset.UTC).toEpochMilli();
    }

    @Override
    public double asDouble() {
        return this.asLong();
    }

    @Override
    @NotNull
    public OffsetDateTime asOffsetDateTime() {
        return this.asLocalDateTime().atOffset(this.offset);
    }

    @Override
    @NotNull
    public LocalDateTime asLocalDateTime() {
        return this.value.atDate(LocalDate.ofEpochDay(0L));
    }

    @Override
    @NotNull
    public LocalDate asLocalDate() {
        return LocalDate.ofEpochDay(0L);
    }

    @Override
    @NotNull
    public LocalTime asLocalTime() {
        return this.value;
    }
}

