/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.comment.Comments;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.except.TomlValueException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive.AbstractTomlPrimitive;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive.TomlPrimitiveType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
final class LocalDateTomlPrimitive
extends AbstractTomlPrimitive<LocalDate> {
    private final LocalDate value;
    private final ZoneOffset offset;

    public LocalDateTomlPrimitive(@NotNull Comments comments, @NotNull LocalDate value, @NotNull ZoneOffset offset) {
        super(comments);
        TomlValueException.checkDate(value);
        this.value = value;
        this.offset = offset;
    }

    public LocalDateTomlPrimitive(@NotNull LocalDate value, @NotNull ZoneOffset offset) {
        this(Comments.empty(), value, offset);
    }

    @Override
    @NotNull
    public TomlPrimitiveType type() {
        return TomlPrimitiveType.LOCAL_DATE;
    }

    @Override
    @NotNull
    public LocalDate value() {
        return this.value;
    }

    @Override
    @NotNull
    ZoneOffset temporalOffset() {
        return this.offset;
    }

    @Override
    @NotNull
    public String asString() {
        StringBuilder sb = new StringBuilder();
        LocalDateTomlPrimitive.writeDate(sb, this.value);
        return sb.toString();
    }

    @Override
    public boolean asBoolean() {
        return true;
    }

    @Override
    public long asLong() {
        return this.value.atTime(0, 0).toInstant(this.offset).toEpochMilli();
    }

    @Override
    public double asDouble() {
        return this.asLong();
    }

    @Override
    @NotNull
    public OffsetDateTime asOffsetDateTime() {
        return this.asLocalDateTime().atOffset(this.offset);
    }

    @Override
    @NotNull
    public LocalDateTime asLocalDateTime() {
        return this.value.atTime(0, 0);
    }

    @Override
    @NotNull
    public LocalDate asLocalDate() {
        return this.value;
    }

    @Override
    @NotNull
    public LocalTime asLocalTime() {
        return LocalTime.of(0, 0);
    }
}

