/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.comment.Comments;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.except.TomlValueException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive.AbstractTomlPrimitive;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive.TomlPrimitiveType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
final class LocalDateTimeTomlPrimitive
extends AbstractTomlPrimitive<LocalDateTime> {
    private final LocalDateTime value;
    private final ZoneOffset offset;

    public LocalDateTimeTomlPrimitive(@NotNull Comments comments, @NotNull LocalDateTime value, @NotNull ZoneOffset offset) {
        super(comments);
        TomlValueException.checkDate(value);
        this.value = value;
        this.offset = offset;
    }

    public LocalDateTimeTomlPrimitive(@NotNull LocalDateTime value, @NotNull ZoneOffset offset) {
        this(Comments.empty(), value, offset);
    }

    @Override
    @NotNull
    public TomlPrimitiveType type() {
        return TomlPrimitiveType.LOCAL_DATE_TIME;
    }

    @Override
    @NotNull
    public LocalDateTime value() {
        return this.value;
    }

    @Override
    @NotNull
    ZoneOffset temporalOffset() {
        return this.offset;
    }

    @Override
    @NotNull
    public String asString() {
        StringBuilder sb = new StringBuilder();
        LocalDateTimeTomlPrimitive.writeDate(sb, this.value.toLocalDate());
        sb.append('T');
        LocalDateTimeTomlPrimitive.writeTime(sb, this.value.toLocalTime());
        return sb.toString();
    }

    @Override
    public boolean asBoolean() {
        return true;
    }

    @Override
    public long asLong() {
        return this.value.toInstant(this.offset).toEpochMilli();
    }

    @Override
    public double asDouble() {
        return this.asLong();
    }

    @Override
    @NotNull
    public OffsetDateTime asOffsetDateTime() {
        return this.value.atOffset(this.offset);
    }

    @Override
    @NotNull
    public LocalDateTime asLocalDateTime() {
        return this.value;
    }

    @Override
    @NotNull
    public LocalDate asLocalDate() {
        return this.value.toLocalDate();
    }

    @Override
    @NotNull
    public LocalTime asLocalTime() {
        return this.value.toLocalTime();
    }
}

