/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.comment.Comments;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive.AbstractTomlPrimitive;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive.TomlPrimitiveType;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
final class IntegerTomlPrimitive
extends AbstractTomlPrimitive<Long> {
    private final long value;

    public IntegerTomlPrimitive(@NotNull Comments comments, long value) {
        super(comments);
        this.value = value;
    }

    public IntegerTomlPrimitive(long value) {
        this(Comments.empty(), value);
    }

    @Override
    @NotNull
    public TomlPrimitiveType type() {
        return TomlPrimitiveType.INTEGER;
    }

    @Override
    @NotNull
    public Long value() {
        return this.value;
    }

    @Override
    @NotNull
    public String asString() {
        return Long.toString(this.value);
    }

    @Override
    public boolean asBoolean() {
        return this.value != 0L;
    }

    @Override
    public long asLong() {
        return this.value;
    }

    @Override
    public double asDouble() {
        return this.value;
    }

    @Override
    @NotNull
    public OffsetDateTime asOffsetDateTime() {
        return Instant.ofEpochMilli(this.value).atOffset(ZoneOffset.UTC);
    }

    @Override
    @NotNull
    public LocalDateTime asLocalDateTime() {
        return LocalDateTime.ofEpochSecond(this.value / 1000L, (int)(this.value % 1000L) * 1000000, ZoneOffset.UTC);
    }

    @Override
    @NotNull
    public Instant asInstant() {
        return Instant.ofEpochMilli(this.value);
    }
}

