/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.comment.Comments;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive.AbstractTomlPrimitive;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive.TomlPrimitiveType;
import java.text.NumberFormat;
import java.util.Locale;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
final class FloatTomlPrimitive
extends AbstractTomlPrimitive<Double> {
    private static final ThreadLocal<NumberFormat> NUMBER_FORMAT = ThreadLocal.withInitial(() -> {
        NumberFormat df = NumberFormat.getInstance(Locale.ROOT);
        df.setMaximumFractionDigits(15);
        df.setMinimumFractionDigits(1);
        df.setGroupingUsed(false);
        return df;
    });
    private final double value;
    private final String chars;

    @NotNull
    private static String autoChars(double value) {
        if (value == Double.POSITIVE_INFINITY) {
            return "inf";
        }
        if (value == Double.NEGATIVE_INFINITY) {
            return "-inf";
        }
        if (Double.isNaN(value)) {
            return "nan";
        }
        if (Double.doubleToLongBits(value) == Long.MIN_VALUE) {
            return "-0.0";
        }
        return NUMBER_FORMAT.get().format(value);
    }

    private FloatTomlPrimitive(@NotNull Comments comments, double value, @NotNull String chars) {
        super(comments);
        this.value = value;
        this.chars = chars;
    }

    public FloatTomlPrimitive(double value, @NotNull String chars) {
        this(Comments.empty(), value, chars);
    }

    public FloatTomlPrimitive(@NotNull Comments comments, double value) {
        this(comments, value, FloatTomlPrimitive.autoChars(value));
    }

    public FloatTomlPrimitive(double value) {
        this(Comments.empty(), value, FloatTomlPrimitive.autoChars(value));
    }

    @Override
    @NotNull
    public TomlPrimitiveType type() {
        return TomlPrimitiveType.FLOAT;
    }

    @Override
    @NotNull
    public Double value() {
        return this.value;
    }

    @Override
    @NotNull
    public String asString() {
        return this.chars;
    }

    @Override
    public boolean asBoolean() {
        return this.value != 0.0;
    }

    @Override
    public long asLong() {
        return (long)this.value;
    }

    @Override
    public double asDouble() {
        return this.value;
    }
}

