/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.comment.Comments;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive.TomlPrimitive;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

@ApiStatus.Internal
abstract class AbstractTomlPrimitive<T extends Serializable>
implements TomlPrimitive {
    protected final Comments comments;

    protected static void writeDigit(@NotNull StringBuilder sb, @Range(from=0L, to=9L) int d) {
        sb.append((char)(d + 48));
    }

    protected static void writeDate(@NotNull StringBuilder sb, @NotNull LocalDate date) {
        int year = date.getYear();
        if (year > 9999) {
            sb.append(year);
        } else {
            AbstractTomlPrimitive.writeDigit(sb, year / 1000);
            AbstractTomlPrimitive.writeDigit(sb, year % 1000 / 100);
            AbstractTomlPrimitive.writeDigit(sb, year % 100 / 10);
            AbstractTomlPrimitive.writeDigit(sb, year % 10);
        }
        sb.append('-');
        int month = date.getMonthValue();
        AbstractTomlPrimitive.writeDigit(sb, month / 10);
        AbstractTomlPrimitive.writeDigit(sb, month % 10);
        sb.append('-');
        int day = date.getDayOfMonth();
        AbstractTomlPrimitive.writeDigit(sb, day / 10);
        AbstractTomlPrimitive.writeDigit(sb, day % 10);
    }

    protected static void writeHourMinute(@NotNull StringBuilder sb, int hour, int minute) {
        AbstractTomlPrimitive.writeDigit(sb, hour / 10);
        AbstractTomlPrimitive.writeDigit(sb, hour % 10);
        sb.append(':');
        AbstractTomlPrimitive.writeDigit(sb, minute / 10);
        AbstractTomlPrimitive.writeDigit(sb, minute % 10);
    }

    protected static void writeTime(@NotNull StringBuilder sb, @NotNull LocalTime time) {
        AbstractTomlPrimitive.writeHourMinute(sb, time.getHour(), time.getMinute());
        sb.append(':');
        int second = time.getSecond();
        AbstractTomlPrimitive.writeDigit(sb, second / 10);
        AbstractTomlPrimitive.writeDigit(sb, second % 10);
        int nano = time.getNano();
        if (nano != 0) {
            int end;
            char[] buf = new char[9];
            for (int i = 0; i < 9; ++i) {
                buf[8 - i] = (char)(nano % 10 + 48);
                nano /= 10;
            }
            for (end = 9; end > 3 && buf[end - 1] == '0'; --end) {
            }
            sb.append('.');
            for (int i = 0; i < end; ++i) {
                sb.append(buf[i]);
            }
        }
    }

    protected AbstractTomlPrimitive(@NotNull Comments comments) {
        this.comments = comments;
    }

    @Override
    @NotNull
    public Comments comments() {
        return this.comments;
    }

    @NotNull
    public abstract T value();

    @ApiStatus.Internal
    @NotNull
    ZoneOffset temporalOffset() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Primitive has no temporal offset");
    }

    public int hashCode() {
        int h = 7;
        h = 31 * h + this.type().hashCode();
        h = 31 * h + this.value().hashCode();
        return h;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TomlPrimitive)) {
            return false;
        }
        TomlPrimitive other = (TomlPrimitive)obj;
        if (this.type() != other.type()) {
            return false;
        }
        return this.value().equals(other.value());
    }

    @NotNull
    public String toString() {
        return "TomlPrimitive[type=" + this.type().name() + ", value=" + this.value() + "]";
    }
}

