/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.array;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.comment.Comments;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.TomlValue;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.array.TomlArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
final class TomlArrayImpl
implements TomlArray {
    private final List<TomlValue> backing;
    private final Comments comments;

    @NotNull
    static TomlArrayImpl copyOf(@NotNull Iterable<? extends TomlValue> src) {
        TomlArrayImpl ret;
        if (src instanceof TomlArray) {
            TomlArrayImpl other = (TomlArrayImpl)src;
            ret = new TomlArrayImpl(other.backing.size(), Comments.copyOf(other.comments));
        } else {
            ret = src instanceof Collection ? new TomlArrayImpl(((Collection)src).size()) : new TomlArrayImpl();
        }
        for (TomlValue tomlValue : src) {
            ret.backing.add(TomlValue.copyOf(tomlValue));
        }
        return ret;
    }

    private TomlArrayImpl(int initialCapacity, @NotNull Comments comments) {
        this.backing = new ArrayList<TomlValue>(initialCapacity);
        this.comments = comments;
    }

    TomlArrayImpl(int initialCapacity) {
        this(initialCapacity, Comments.empty());
    }

    TomlArrayImpl() {
        this(10, Comments.empty());
    }

    @Override
    @NotNull
    public Comments comments() {
        return this.comments;
    }

    @Override
    public int size() {
        return this.backing.size();
    }

    @Override
    @NotNull
    public TomlValue get(int index) throws IndexOutOfBoundsException {
        return this.backing.get(index);
    }

    @Override
    public void add(TomlValue value) {
        if (value == null) {
            throw new NullPointerException("Cannot add null to TomlArray");
        }
        this.backing.add(value);
    }

    @Override
    @NotNull
    public TomlValue remove(int index) throws IndexOutOfBoundsException {
        return this.backing.remove(index);
    }

    @Override
    @NotNull
    public TomlValue set(int index, TomlValue value) throws IndexOutOfBoundsException {
        if (value == null) {
            throw new NullPointerException("Cannot insert null into TomlArray");
        }
        return this.backing.set(index, value);
    }

    @Override
    @NotNull
    public Iterator<TomlValue> iterator() {
        return this.backing.iterator();
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < this.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(this.get(i));
        }
        sb.append("]");
        return sb.toString();
    }
}

