/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.array;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.TomlValue;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.array.TomlArrayImpl;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive.TomlPrimitive;
import java.lang.reflect.Array;
import java.util.RandomAccess;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@ApiStatus.NonExtendable
public interface TomlArray
extends Iterable<TomlValue>,
RandomAccess,
TomlValue {
    @Contract(value="_ -> new")
    @NotNull
    public static TomlArray create(int initialCapacity) {
        return new TomlArrayImpl(initialCapacity);
    }

    @Contract(value="-> new")
    @NotNull
    public static TomlArray create() {
        return new TomlArrayImpl();
    }

    @Contract(value="_ -> new")
    @ApiStatus.AvailableSince(value="0.6.3")
    @NotNull
    public static TomlArray copyOf(@NotNull Iterable<? extends TomlValue> array) {
        return TomlArrayImpl.copyOf(array);
    }

    @Contract(pure=true)
    public int size();

    @NotNull
    public TomlValue get(int var1) throws IndexOutOfBoundsException;

    @Contract(value="null -> fail", mutates="this")
    public void add(TomlValue var1);

    @Contract(mutates="this")
    default public void add(@NotNull String value) {
        this.add(TomlPrimitive.of(value));
    }

    @Contract(mutates="this")
    default public void add(boolean value) {
        this.add(TomlPrimitive.of(value));
    }

    @Contract(mutates="this")
    default public void add(long value) {
        this.add(TomlPrimitive.of(value));
    }

    @Contract(mutates="this")
    default public void add(int value) {
        this.add(TomlPrimitive.of(value));
    }

    @Contract(mutates="this")
    default public void add(double value) {
        this.add(TomlPrimitive.of(value));
    }

    @Contract(mutates="this")
    default public void add(float value) {
        this.add(TomlPrimitive.of(value));
    }

    default public void addAll(@NotNull Iterable<? extends TomlValue> source) {
        for (TomlValue tomlValue : source) {
            this.add(tomlValue);
        }
    }

    @Contract(value="null -> false")
    default public boolean contains(TomlValue value) {
        if (value == null) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).equals(value)) continue;
            return true;
        }
        return false;
    }

    @Contract(value="_ -> !null", mutates="this")
    public TomlValue remove(int var1) throws IndexOutOfBoundsException;

    @Contract(value="null -> false", mutates="this")
    default public boolean remove(TomlValue value) {
        if (value == null) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).equals(value)) continue;
            this.remove(i);
            return true;
        }
        return false;
    }

    @Contract(value="_, null -> fail", mutates="this")
    @NotNull
    public TomlValue set(int var1, TomlValue var2) throws IndexOutOfBoundsException;

    @Contract(value="-> new")
    @NotNull
    default public @NotNull TomlValue @NotNull [] toArray() {
        int len = this.size();
        TomlValue[] vs = new TomlValue[len];
        for (int i = 0; i < len; ++i) {
            vs[i] = this.get(i);
        }
        return vs;
    }

    @Contract(value="_ -> new")
    @NotNull
    default public <T extends TomlValue> @NotNull T @NotNull [] toArray(@NotNull Class<T> valueType) throws ClassCastException {
        int len = this.size();
        TomlValue[] ret = (TomlValue[])Array.newInstance(valueType, len);
        for (int i = 0; i < len; ++i) {
            ret[i] = (TomlValue)valueType.cast(this.get(i));
        }
        return ret;
    }
}

