/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive.TomlPrimitive;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public final class UnsafePrimitives {
    private static final Constructor<?> FLOAT_WITH_CHARS;

    @Contract(value="_, _ -> new")
    @NotNull
    public static TomlPrimitive createFloat(double v, @NotNull String chars) {
        TomlPrimitive ret;
        if (FLOAT_WITH_CHARS == null) {
            return TomlPrimitive.of(v);
        }
        try {
            ret = (TomlPrimitive)FLOAT_WITH_CHARS.newInstance(v, chars);
        }
        catch (ExceptionInInitializerError | InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new AssertionError("Unexpected error in constructor/initializer", e);
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError("Unexpected reflection error", e);
        }
        return ret;
    }

    private UnsafePrimitives() {
    }

    static {
        Constructor<?> con = null;
        try {
            Class<?> cls = Class.forName("fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive.FloatTomlPrimitive");
            con = cls.getDeclaredConstructor(Double.TYPE, String.class);
            con.setAccessible(true);
        }
        catch (ReflectiveOperationException | SecurityException e) {
            Logger.getLogger("jtoml").log(Level.WARNING, "Failed to access float constructor (please report this)", e);
        }
        FLOAT_WITH_CHARS = con;
    }
}

