/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.comment.Comments;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.array.TomlArray;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive.TomlPrimitive;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.table.TomlTable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@ApiStatus.NonExtendable
public interface TomlValue {
    @Contract(value="_ -> new")
    @ApiStatus.AvailableSince(value="0.6.4")
    @NotNull
    public static TomlValue copyOf(@NotNull TomlValue other) {
        if (other.isTable()) {
            return TomlTable.copyOf(other.asTable());
        }
        if (other.isArray()) {
            return TomlArray.copyOf(other.asArray());
        }
        return TomlPrimitive.copyOf(other.asPrimitive());
    }

    @ApiStatus.AvailableSince(value="0.6.0")
    @NotNull
    public Comments comments();

    default public boolean isPrimitive() {
        return this instanceof TomlPrimitive;
    }

    @NotNull
    default public TomlPrimitive asPrimitive() throws UnsupportedOperationException {
        if (this instanceof TomlPrimitive) {
            return (TomlPrimitive)this;
        }
        throw new UnsupportedOperationException();
    }

    default public boolean isArray() {
        return this instanceof TomlArray;
    }

    @NotNull
    default public TomlArray asArray() throws UnsupportedOperationException {
        if (this instanceof TomlArray) {
            return (TomlArray)this;
        }
        throw new UnsupportedOperationException();
    }

    default public boolean isTable() {
        return this instanceof TomlTable;
    }

    @NotNull
    default public TomlTable asTable() throws UnsupportedOperationException {
        if (this instanceof TomlTable) {
            return (TomlTable)this;
        }
        throw new UnsupportedOperationException();
    }
}

