/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.comment.Comments;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.TomlValue;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.array.TomlArray;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive.TomlPrimitive;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.table.TomlTable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class FlaggedTomlValue
implements TomlValue {
    private static final int F_CONSTANT = 1;
    private static final int F_NON_REUSABLE = 2;
    private static final int F_NON_KEY_EXTENDABLE = 4;
    private final TomlValue backing;
    private int flags = 0;

    @NotNull
    public static FlaggedTomlValue wrap(@NotNull TomlValue value) {
        if (value instanceof FlaggedTomlValue) {
            return (FlaggedTomlValue)value;
        }
        return new FlaggedTomlValue(value);
    }

    public static boolean isConstant(@NotNull TomlValue value) {
        if (value instanceof FlaggedTomlValue) {
            return ((FlaggedTomlValue)value).isConstant();
        }
        return false;
    }

    public static boolean isNonReusable(@NotNull TomlValue value) {
        if (value instanceof FlaggedTomlValue) {
            return ((FlaggedTomlValue)value).isNonReusable();
        }
        return false;
    }

    public static boolean isNonKeyExtendable(@NotNull TomlValue value) {
        if (value instanceof FlaggedTomlValue) {
            return ((FlaggedTomlValue)value).isNonKeyExtendable();
        }
        return false;
    }

    private FlaggedTomlValue(@NotNull TomlValue backing) {
        this.backing = backing;
    }

    @Contract(pure=true)
    @NotNull
    public TomlValue handle() {
        return this.backing;
    }

    private boolean getFlag(int f) {
        return (this.flags & f) != 0;
    }

    private void setFlag(int f, boolean value) {
        this.flags = value ? (this.flags |= f) : (this.flags &= ~f);
    }

    public boolean isConstant() {
        return this.getFlag(1);
    }

    public void setConstant(boolean constant) {
        this.setFlag(1, constant);
    }

    public boolean isNonReusable() {
        return this.getFlag(2);
    }

    public void setNonReusable(boolean nonReusable) {
        this.setFlag(2, nonReusable);
    }

    public boolean isNonKeyExtendable() {
        return this.getFlag(4);
    }

    public void setNonKeyExtendable(boolean nonKeyExtendable) {
        this.setFlag(4, nonKeyExtendable);
    }

    @Override
    @NotNull
    public Comments comments() {
        return this.backing.comments();
    }

    @Override
    public boolean isPrimitive() {
        return this.backing.isPrimitive();
    }

    @Override
    @NotNull
    public TomlPrimitive asPrimitive() throws UnsupportedOperationException {
        return this.backing.asPrimitive();
    }

    @Override
    public boolean isArray() {
        return this.backing.isArray();
    }

    @Override
    @NotNull
    public TomlArray asArray() throws UnsupportedOperationException {
        return this.backing.asArray();
    }

    @Override
    public boolean isTable() {
        return this.backing.isTable();
    }

    @Override
    @NotNull
    public TomlTable asTable() throws UnsupportedOperationException {
        return this.backing.asTable();
    }

    public int hashCode() {
        return this.backing.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TomlValue)) {
            return false;
        }
        if (obj instanceof FlaggedTomlValue) {
            return this.backing.equals(((FlaggedTomlValue)obj).backing);
        }
        return this.backing.equals(obj);
    }

    @NotNull
    public String toString() {
        return this.backing.toString();
    }
}

