/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.option.prop;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public final class SpacingPolicy {
    public static final SpacingPolicy NONE = new SpacingPolicy(0);
    public static final SpacingPolicy STANDARD = new SpacingPolicy(0x1000000);
    private final int data;

    @Contract(value="-> new")
    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    private SpacingPolicy(int data) {
        this.data = data;
    }

    public @Range(from=0L, to=255L) int preTable() {
        return this.data >> 24 & 0xFF;
    }

    public @Range(from=0L, to=255L) int postTable() {
        return this.data >> 16 & 0xFF;
    }

    public @Range(from=0L, to=255L) int preStatement() {
        return this.data >> 8 & 0xFF;
    }

    public @Range(from=0L, to=255L) int postStatement() {
        return this.data & 0xFF;
    }

    public int hashCode() {
        return Integer.hashCode(this.data);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SpacingPolicy)) {
            return false;
        }
        return this.data == ((SpacingPolicy)obj).data;
    }

    @NotNull
    public String toString() {
        return "SpacingPolicy[preTable=" + this.preTable() + ", postTable=" + this.postTable() + ", preStatement=" + this.preStatement() + ", postStatement=" + this.postStatement() + "]";
    }

    public static final class Builder {
        private final int[] values = new int[4];

        @Contract(value="_, _ -> this")
        @NotNull
        private Builder set(int index, int value) {
            if (value < 0) {
                throw new IllegalArgumentException("Spacing may not be negative");
            }
            if (value > 255) {
                throw new IllegalArgumentException("Spacing is too large (" + value + " > 255)");
            }
            this.values[index] = value;
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder preTable(@Range(from=0L, to=255L) int spacing) {
            return this.set(0, spacing);
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder postTable(@Range(from=0L, to=255L) int spacing) {
            return this.set(1, spacing);
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder preStatement(@Range(from=0L, to=255L) int spacing) {
            return this.set(2, spacing);
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder postStatement(@Range(from=0L, to=255L) int spacing) {
            return this.set(3, spacing);
        }

        @Contract(value="-> new")
        @NotNull
        public SpacingPolicy build() {
            return new SpacingPolicy(this.values[0] << 24 | this.values[1] << 16 | this.values[2] << 8 | this.values[3]);
        }
    }
}

