/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.option.prop;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public final class PaddingPolicy {
    public static final PaddingPolicy NONE = new PaddingPolicy(0);
    public static final PaddingPolicy STANDARD = new PaddingPolicy(65793);
    private final int data;

    @Contract(value="-> new")
    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    private PaddingPolicy(int data) {
        this.data = data;
    }

    public @Range(from=0L, to=255L) int tablePadding() {
        return this.data >> 24 & 0xFF;
    }

    public @Range(from=0L, to=255L) int inlineTablePadding() {
        return this.data >> 16 & 0xFF;
    }

    public @Range(from=0L, to=255L) int arrayPadding() {
        return this.data >> 8 & 0xFF;
    }

    public @Range(from=0L, to=255L) int elementPadding() {
        return this.data & 0xFF;
    }

    public int hashCode() {
        return Integer.hashCode(this.data);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PaddingPolicy)) {
            return false;
        }
        return this.data == ((PaddingPolicy)obj).data;
    }

    @NotNull
    public String toString() {
        return "PaddingPolicy[tablePadding=" + this.tablePadding() + ", inlineTablePadding=" + this.inlineTablePadding() + ", arrayPadding=" + this.arrayPadding() + ", elementPadding=" + this.elementPadding() + "]";
    }

    public static final class Builder {
        private final int[] values = new int[4];

        @Contract(value="_, _ -> this")
        @NotNull
        private Builder set(int index, int value) {
            if (value < 0) {
                throw new IllegalArgumentException("Padding may not be negative");
            }
            if (value > 255) {
                throw new IllegalArgumentException("Padding is too large (" + value + " > 255)");
            }
            this.values[index] = value;
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder tablePadding(@Range(from=0L, to=255L) int padding) {
            return this.set(0, padding);
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder inlineTablePadding(@Range(from=0L, to=255L) int padding) {
            return this.set(1, padding);
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder arrayPadding(@Range(from=0L, to=255L) int padding) {
            return this.set(2, padding);
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder elementPadding(@Range(from=0L, to=255L) int padding) {
            return this.set(3, padding);
        }

        @Contract(value="-> new")
        @NotNull
        public PaddingPolicy build() {
            return new PaddingPolicy(this.values[0] << 24 | this.values[1] << 16 | this.values[2] << 8 | this.values[3]);
        }
    }
}

