/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.option.prop;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public final class IndentationPolicy {
    public static final IndentationPolicy NONE = new IndentationPolicy('\u0000', 0);
    public static final IndentationPolicy STANDARD = new IndentationPolicy('\t', 256);
    private final char indentChar;
    private final int data;

    @Contract(value="-> new")
    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    private IndentationPolicy(char indentChar, int data) {
        this.indentChar = indentChar;
        this.data = data;
    }

    public char indentChar() {
        return this.indentChar;
    }

    public @Range(from=0L, to=255L) int globalIndent() {
        return this.data >> 24 & 0xFF;
    }

    public @Range(from=0L, to=255L) int constantIndent() {
        return this.data >> 16 & 0xFF;
    }

    public @Range(from=0L, to=255L) int variableIndent() {
        return this.data >> 8 & 0xFF;
    }

    public @Range(from=0L, to=255L) int postIndent() {
        return this.data & 0xFF;
    }

    public int hashCode() {
        return Integer.hashCode(this.data);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IndentationPolicy)) {
            return false;
        }
        IndentationPolicy other = (IndentationPolicy)obj;
        if (this.indentChar != other.indentChar) {
            return false;
        }
        return this.data == other.data;
    }

    @NotNull
    public String toString() {
        char c = this.indentChar;
        return "IndentPolicy[indentChar=0x" + Character.forDigit(c >> 4, 16) + Character.forDigit(c & 0xF, 16) + ", globalIndent=" + this.globalIndent() + ", constantIndent=" + this.constantIndent() + ", variableIndent=" + this.variableIndent() + ", postIndent=" + this.postIndent() + "]";
    }

    public static final class Builder {
        private final int[] values = new int[]{0, 0, 0, 0};
        private char indentChar = (char)9;

        @Contract(value="_ -> this")
        @NotNull
        public Builder indentChar(char indentChar) {
            if (indentChar != ' ' && indentChar != '\t') {
                throw new IllegalArgumentException("Invalid indent character (expected TAB or SPACE)");
            }
            this.indentChar = indentChar;
            return this;
        }

        @Contract(value="_, _ -> this")
        @NotNull
        private Builder setValue(int index, int value) {
            if (value < 0) {
                throw new IllegalArgumentException("Indentation level may not be negative");
            }
            if (value > 255) {
                throw new IllegalArgumentException("Indentation level is too large (" + value + " > 255)");
            }
            this.values[index] = value;
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder globalIndent(@Range(from=0L, to=255L) int indent) {
            return this.setValue(0, indent);
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder constantIndent(@Range(from=0L, to=255L) int indent) {
            return this.setValue(1, indent);
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder variableIndent(@Range(from=0L, to=255L) int indent) {
            return this.setValue(2, indent);
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder postIndent(@Range(from=0L, to=255L) int indent) {
            return this.setValue(3, indent);
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder scale(int amount) {
            if (amount < 0) {
                throw new IllegalArgumentException("Scale may not be negative");
            }
            for (int i = 0; i < 4; ++i) {
                int product;
                int cur = this.values[i];
                try {
                    product = Math.multiplyExact(cur, amount);
                    if (product > 255) {
                        product = -1;
                    }
                }
                catch (ArithmeticException e) {
                    product = -1;
                }
                if (product == -1) {
                    throw new IllegalArgumentException("Scale is too large (" + cur + " * " + amount + " > 255)");
                }
                this.values[i] = product;
            }
            return this;
        }

        @Contract(value="-> new")
        @NotNull
        public IndentationPolicy build() {
            return new IndentationPolicy(this.indentChar, this.values[0] << 24 | this.values[1] << 16 | this.values[2] << 8 | this.values[3]);
        }
    }
}

