/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.option;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.option.JTomlOption;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JTomlOptions {
    private static final JTomlOptions DEFAULTS = new JTomlOptions(new Object[0]);
    private final Object[] values;

    @Contract(pure=true)
    @NotNull
    public static JTomlOptions defaults() {
        return DEFAULTS;
    }

    @Contract(value="-> new")
    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    private JTomlOptions(@Nullable Object @NotNull [] values) {
        this.values = values;
    }

    @Contract(pure=true)
    @NotNull
    public <T> T get(@NotNull JTomlOption<T> option) {
        int o = option.ordinal();
        if (o < 0 || o >= this.values.length) {
            return option.defaultValue();
        }
        Object obj = this.values[o];
        return obj == null ? option.defaultValue() : option.valueClass().cast(obj);
    }

    @Contract(pure=true)
    public boolean get(@NotNull JTomlOption.Bool option) {
        return this.get((JTomlOption)option);
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder("JTomlOptions[");
        JTomlOption<?>[] opts = JTomlOption.values();
        for (int i = 0; i < opts.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            JTomlOption<?> opt = opts[i];
            sb.append("\n\t").append(opt.name()).append(" = ").append(this.get(opt));
        }
        sb.append("\n]");
        return sb.toString();
    }

    public static final class Builder {
        private static final int CAPACITY = JTomlOption.values().length;
        private final Object[] values = new Object[CAPACITY];
        private int max = -1;

        private Builder() {
        }

        @Contract(value="_, _ -> this", mutates="this")
        @NotNull
        public <T> Builder set(@NotNull JTomlOption<T> key, @Nullable T value) throws IllegalArgumentException {
            int idx = key.ordinal();
            if (idx < 0 || idx >= CAPACITY) {
                throw new IllegalStateException("Illegal ordinal (" + idx + ")");
            }
            if (value != null && !key.isLegal(value)) {
                throw new IllegalArgumentException("Illegal value (" + value + ") for " + key.name());
            }
            this.values[idx] = value;
            if (idx > this.max) {
                this.max = idx;
            }
            return this;
        }

        @Contract(value="_ -> this", mutates="this")
        @NotNull
        public Builder unset(@NotNull JTomlOption<?> key) {
            return this.set(key, null);
        }

        @Contract(value="-> new")
        @NotNull
        public JTomlOptions build() {
            int count = this.max + 1;
            Object[] cpy = new Object[count];
            System.arraycopy(this.values, 0, cpy, 0, count);
            return new JTomlOptions(cpy);
        }
    }
}

