/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.key;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.key.ArrayTomlKey;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.key.JoinedTomlKey;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.key.SlicedTomlKey;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@ApiStatus.NonExtendable
public interface TomlKey
extends Collection<String>,
Comparable<TomlKey> {
    @Contract(value="_ -> new")
    @NotNull
    public static TomlKey parse(@NotNull CharSequence key) throws IllegalArgumentException {
        try {
            return ArrayTomlKey.parse(key);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Failed to parse TOML key (" + key + ")", e);
        }
    }

    @NotNull
    public static TomlKey join(@NotNull TomlKey first, TomlKey ... additional) {
        return JoinedTomlKey.join(first, additional);
    }

    @SafeVarargs
    @ApiStatus.Experimental
    @Contract(value="_ -> new")
    @NotNull
    public static <S extends CharSequence> TomlKey literal(S ... parts) {
        int len = parts.length;
        String[] cpy = new String[len];
        for (int i = 0; i < len; ++i) {
            cpy[i] = parts[i].toString();
        }
        return new ArrayTomlKey(cpy);
    }

    @Override
    public int size();

    @NotNull
    default public String get(int index) throws IndexOutOfBoundsException {
        String ret;
        int size = this.size();
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds for length " + size);
        }
        Iterator iter = this.iterator();
        do {
            if (!iter.hasNext()) {
                throw new ConcurrentModificationException();
            }
            ret = (String)iter.next();
        } while (--index >= 0);
        return ret;
    }

    @Override
    @NotNull
    public Stream<String> stream();

    @Contract(value="_, _ -> new")
    @NotNull
    default public TomlKey slice(int fromIndex, int toIndex) {
        return SlicedTomlKey.of(this, fromIndex, toIndex - fromIndex);
    }

    @NotNull
    public String toString();

    @Override
    default public int compareTo(@NotNull TomlKey o) {
        int lc;
        int sl;
        int ol;
        int ml = this.size();
        if (ml < (ol = o.size())) {
            sl = ml;
            lc = -1;
        } else if (ml > ol) {
            sl = ol;
            lc = 1;
        } else {
            sl = ml;
            lc = 0;
        }
        Iterator mi = this.iterator();
        Iterator oi = o.iterator();
        for (int i = 0; i < sl; ++i) {
            int pc = ((String)mi.next()).compareTo((String)oi.next());
            if (pc == 0) continue;
            return pc;
        }
        return lc;
    }
}

