/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.key;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.key.AbstractTomlKey;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.key.TomlKey;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
final class JoinedTomlKey
extends AbstractTomlKey {
    private final TomlKey[] sub;
    private final int totalSize;

    @NotNull
    public static TomlKey join(@NotNull TomlKey first, TomlKey ... additional) {
        TomlKey[] parts;
        int totalSize;
        int offset;
        if (additional.length == 0) {
            return first;
        }
        if (first instanceof JoinedTomlKey) {
            JoinedTomlKey qual = (JoinedTomlKey)first;
            TomlKey[] qualSub = qual.sub;
            offset = qualSub.length;
            totalSize = qual.totalSize;
            parts = new TomlKey[additional.length + offset];
            System.arraycopy(qualSub, 0, parts, 0, offset);
        } else if (first.isEmpty()) {
            parts = new TomlKey[additional.length];
            offset = 0;
            totalSize = 0;
        } else {
            parts = new TomlKey[additional.length + 1];
            offset = 1;
            totalSize = first.size();
            parts[0] = first;
        }
        for (int i = 0; i < additional.length; ++i) {
            TomlKey next;
            parts[offset + i] = next = additional[i];
            totalSize += next.size();
        }
        return new JoinedTomlKey(parts, totalSize);
    }

    private JoinedTomlKey(@NotNull @NotNull TomlKey @NotNull [] sub, int totalSize) {
        this.sub = sub;
        this.totalSize = totalSize;
    }

    @Override
    public int size() {
        return this.totalSize;
    }

    @Override
    @NotNull
    public Stream<String> stream() {
        Stream<String> ret = this.sub[0].stream();
        for (int i = 1; i < this.sub.length; ++i) {
            ret = Stream.concat(ret, this.sub[i].stream());
        }
        return ret;
    }
}

