/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.key;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.key.AbstractTomlKey;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.RandomAccess;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

@ApiStatus.Internal
final class ArrayTomlKey
extends AbstractTomlKey
implements RandomAccess {
    private final String[] data;

    @NotNull
    public static ArrayTomlKey parse(@NotNull CharSequence str) throws IllegalArgumentException {
        if (str instanceof String) {
            str = CharBuffer.wrap(str);
        }
        int count = 0;
        LinkedInt linkedDots = null;
        char quot = '\u0000';
        boolean escaped = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (escaped) {
                escaped = false;
                continue;
            }
            if (quot != '\u0000') {
                if (quot == '\"' && c == '\\') {
                    escaped = true;
                    continue;
                }
                if (c != quot) continue;
                quot = '\u0000';
                continue;
            }
            if (c == '\"' || c == '\'') {
                if (i != 0 && str.charAt(i - 1) != '.') {
                    throw new IllegalArgumentException("Disallowed quote char at index " + i);
                }
                quot = c;
                continue;
            }
            if (c != '.') continue;
            linkedDots = new LinkedInt(i, linkedDots);
            ++count;
        }
        if (count == 0) {
            return new ArrayTomlKey(new String[]{ArrayTomlKey.parseSingle(0, str)});
        }
        String[] parts = new String[count + 1];
        int b = str.length();
        for (int i = count; i > 0; --i) {
            parts[i] = ArrayTomlKey.parseSingle(i, str.subSequence(linkedDots.value + 1, b));
            b = linkedDots.value;
            linkedDots = linkedDots.next;
        }
        parts[0] = ArrayTomlKey.parseSingle(0, str.subSequence(0, b));
        return new ArrayTomlKey(parts);
    }

    @NotNull
    private static String parseSingle(int index, @NotNull CharSequence str) throws IllegalArgumentException {
        int len = str.length();
        if (len == 0) {
            throw new IllegalArgumentException("Part #" + index + " is empty");
        }
        char c0 = str.charAt(0);
        if (c0 == '\"') {
            if (len == 1 || str.charAt(len - 1) != '\"') {
                throw new IllegalArgumentException("Part #" + index + " is missing closing quotation mark");
            }
            StringBuilder sb = null;
            boolean decoding = false;
            for (int i = 1; i < len - 1; ++i) {
                int skip;
                char ci = str.charAt(i);
                if (ArrayTomlKey.isValidBasicUnescaped(ci)) {
                    if (!decoding) continue;
                    sb.append(ci);
                    continue;
                }
                if (ci != '\\') {
                    throw new IllegalArgumentException("Part #" + index + " has illegal char at index " + i);
                }
                if (!decoding) {
                    decoding = true;
                    sb = new StringBuilder(len);
                    sb.append(str.subSequence(1, i));
                }
                if ((skip = ArrayTomlKey.decodeEscape(sb, str.subSequence(i + 1, len - 1))) == -1) {
                    throw new IllegalArgumentException("Part #" + index + " has illegal escape sequence at index " + i);
                }
                i += skip;
            }
            if (decoding) {
                return sb.toString();
            }
            return str.subSequence(1, len - 1).toString();
        }
        if (c0 == '\'') {
            if (len == 1 || str.charAt(len - 1) != '\'') {
                throw new IllegalArgumentException("Part #" + index + " is missing closing single quote");
            }
            for (int i = 1; i < len - 1; ++i) {
                if (str.charAt(i) != '\'') continue;
                throw new IllegalArgumentException("Part #" + index + " has illegal char at index " + i);
            }
            return str.subSequence(1, len - 1).toString();
        }
        for (int i = 0; i < len; ++i) {
            if (ArrayTomlKey.isValidBare(str.charAt(i))) continue;
            throw new IllegalArgumentException("Part #" + index + " has illegal char at index " + i);
        }
        return str.toString();
    }

    private static @Range(from=-1L, to=0x7FFFFFFFL) int decodeEscape(@NotNull StringBuilder dest, @NotNull CharSequence str) {
        int len = str.length();
        if (len == 0) {
            return -1;
        }
        int ul = 5;
        char c0 = str.charAt(0);
        switch (c0) {
            case 'b': {
                dest.append('\b');
                return 1;
            }
            case 't': {
                dest.append('\t');
                return 1;
            }
            case 'n': {
                dest.append('\n');
                return 1;
            }
            case 'f': {
                dest.append('\f');
                return 1;
            }
            case 'r': {
                dest.append('\r');
                return 1;
            }
            case '\"': {
                dest.append('\"');
                return 1;
            }
            case '\\': {
                dest.append("\\");
                return 1;
            }
            case 'U': {
                ul = 9;
            }
            case 'u': {
                if (len < ul) {
                    return -1;
                }
                int value = 0;
                for (int i = 1; i < ul; ++i) {
                    int digit = Character.digit(str.charAt(i), 16);
                    if (digit == -1) {
                        return -1;
                    }
                    value = value << 4 | digit;
                }
                if (ul == 9) {
                    dest.append(Character.toChars(value));
                } else {
                    dest.append((char)value);
                }
                return ul;
            }
        }
        return -1;
    }

    ArrayTomlKey(@NotNull @NotNull String @NotNull [] data) {
        this.data = data;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    @NotNull
    public String get(int index) throws IndexOutOfBoundsException {
        return this.data[index];
    }

    @Override
    @NotNull
    public Stream<String> stream() {
        return Arrays.stream(this.data);
    }

    private static final class LinkedInt {
        final int value;
        final LinkedInt next;

        LinkedInt(int value, LinkedInt next) {
            this.value = value;
            this.next = next;
        }
    }
}

