/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.key;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.key.TomlKey;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.StringJoiner;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
abstract class AbstractTomlKey
extends AbstractCollection<String>
implements TomlKey {
    AbstractTomlKey() {
    }

    protected static boolean isValidBare(char c) {
        if ('A' <= c && c <= 'Z') {
            return true;
        }
        if ('a' <= c && c <= 'z') {
            return true;
        }
        if ('0' <= c && c <= '9') {
            return true;
        }
        return c == '_' || c == '-';
    }

    protected static boolean isValidBasicUnescaped(char c) {
        if (c < ' ') {
            return c == '\t';
        }
        return c != '\"' && c != '\\' && c != '\u007f';
    }

    @NotNull
    protected static String basicEscape(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\"': {
                return "\\\"";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return new String(new char[]{'\\', 'u', Character.forDigit(c >> 12 & 0xF, 16), Character.forDigit(c >> 8 & 0xF, 16), Character.forDigit(c >> 4 & 0xF, 16), Character.forDigit(c & 0xF, 16)});
    }

    @Override
    @NotNull
    public abstract Stream<String> stream();

    @Override
    @NotNull
    public Iterator<String> iterator() {
        return this.stream().iterator();
    }

    @Override
    public int hashCode() {
        int h = 0;
        Iterator<String> iter = this.iterator();
        if (iter.hasNext()) {
            while (true) {
                String next = iter.next();
                for (int i = 0; i < next.length(); ++i) {
                    h = 31 * h + next.charAt(i);
                }
                boolean cont = iter.hasNext();
                if (!cont) break;
                h = 31 * h + 46;
            }
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TomlKey)) {
            return false;
        }
        TomlKey other = (TomlKey)obj;
        int len = this.size();
        if (len != other.size()) {
            return false;
        }
        Iterator<String> a = this.iterator();
        Iterator b = other.iterator();
        for (int i = 0; i < len; ++i) {
            if (a.next().equals(b.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public String toString() {
        StringJoiner sj = new StringJoiner(".");
        for (String part : this) {
            sj.add(this.encodePart(part));
        }
        return sj.toString();
    }

    @NotNull
    protected CharSequence encodePart(@NotNull CharSequence part) {
        int len = part.length();
        if (len == 0) {
            return "\"\"";
        }
        StringBuilder sb = null;
        boolean encoding = false;
        for (int i = 0; i < len; ++i) {
            char c = part.charAt(i);
            if (!encoding) {
                if (AbstractTomlKey.isValidBare(c)) continue;
                encoding = true;
                sb = new StringBuilder(len * 5 / 3);
                sb.append('\"').append(part.subSequence(0, i));
            }
            if (AbstractTomlKey.isValidBasicUnescaped(c)) {
                sb.append(c);
                continue;
            }
            sb.append(AbstractTomlKey.basicEscape(c));
        }
        if (encoding) {
            return sb.append('\"');
        }
        return part;
    }
}

