/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.io.source;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.except.TomlException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.except.TomlIOException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.io.source.CharSource;
import java.io.EOFException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public final class StringCharSource
implements CharSource {
    private final String string;
    private int head;

    public StringCharSource(@NotNull String string) {
        this.string = string;
        this.head = 0;
    }

    @Override
    public @Range(from=-1L, to=65535L) int next() throws TomlException {
        if (this.head >= this.string.length()) {
            return -1;
        }
        return this.string.charAt(this.head++);
    }

    @Override
    public char nextChar() throws TomlException {
        if (this.head >= this.string.length()) {
            TomlIOException.rethrow(new EOFException("Unexpected end of string"));
        }
        return this.string.charAt(this.head++);
    }

    @Override
    public void close() throws TomlException {
    }
}

