/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.io.source;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.except.TomlException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.except.TomlIOException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.except.parse.TomlBomException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.except.parse.TomlCodingException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.io.source.CharSource;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.option.prop.OrderMarkPolicy;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public final class StreamCharSource
extends FilterInputStream
implements CharSource {
    private static final int BOM_ALLOWED = 1;
    private static final int BOM_REQUIRED = 2;
    private static final int BOM_CHECKED = 4;
    private static final int BOM_READ = 8;
    private int flags;
    private int carry;

    public StreamCharSource(@NotNull InputStream in, @NotNull OrderMarkPolicy bomPolicy) {
        super(in);
        int flags = 0;
        switch (bomPolicy) {
            case ALWAYS: {
                flags |= 2;
            }
            case IF_PRESENT: {
                flags |= 1;
            }
        }
        this.flags = flags;
        this.carry = -1;
    }

    public boolean didReadBOM() {
        return (this.flags & 8) != 0;
    }

    private @Range(from=-1L, to=255L) int readSingle() throws TomlException {
        try {
            return this.in.read();
        }
        catch (IOException e) {
            TomlIOException.rethrow(e);
            return -1;
        }
    }

    private @Range(from=0L, to=255L) int readContinuation() throws TomlException {
        int b = this.readSingle();
        if (b == -1 || (b & 0xC0) != 128) {
            throw new TomlCodingException("Truncated encoding");
        }
        return b;
    }

    private @Range(from=-1L, to=65535L) int readChar() throws TomlException {
        int carry = this.carry;
        if (carry != -1) {
            this.carry = -1;
            return carry;
        }
        int b0 = this.readSingle();
        if (b0 == -1) {
            return -1;
        }
        if ((b0 & 0x80) == 0) {
            return b0;
        }
        if ((b0 & 0x40) == 0) {
            throw new TomlCodingException("Illegal first byte (continuation byte)");
        }
        if ((b0 & 0x20) == 0) {
            if (b0 == 192 || b0 == 193) {
                throw new TomlCodingException("Illegal byte (" + b0 + ")");
            }
            int b1 = this.readContinuation();
            int c = (b0 & 0x1F) << 6 | b1 & 0x3F;
            if (c < 128) {
                throw new TomlCodingException("Overlong encoding");
            }
            return c;
        }
        if ((b0 & 0x10) == 0) {
            int b2;
            int b1 = this.readContinuation();
            int c = (b0 & 0xF) << 12 | (b1 & 0x3F) << 6 | (b2 = this.readContinuation()) & 0x3F;
            if (c < 2048) {
                throw new TomlCodingException("Overlong encoding");
            }
            if (55296 <= c && c <= 57343) {
                throw new TomlCodingException("Illegal codepoint (UTF-16 surrogate)");
            }
            return c;
        }
        if ((b0 & 8) == 0) {
            int b3;
            int b2;
            if (b0 >= 245) {
                throw new TomlCodingException("Illegal byte (" + b0 + ")");
            }
            int b1 = this.readContinuation();
            int c = (b0 & 7) << 18 | (b1 & 0x3F) << 12 | ((b2 = this.readContinuation()) & 0x3F) << 6 | (b3 = this.readContinuation()) & 0x3F;
            if (c < 65536) {
                throw new TomlCodingException("Overlong encoding");
            }
            if (c > 0x10FFFF) {
                throw new TomlCodingException("Codepoint too large (" + c + ")");
            }
            this.carry = (c -= 65536) & 0x3FF | 0xDC00;
            return c >> 10 | 0xD800;
        }
        throw new TomlCodingException("Illegal first byte (" + b0 + ")");
    }

    @Override
    public @Range(from=-1L, to=65535L) int next() throws TomlException {
        int c = this.readChar();
        if ((this.flags & 4) == 0) {
            this.flags |= 4;
            if (c == 65279) {
                if ((this.flags & 1) == 0) {
                    throw new TomlBomException("Source data contains a BOM");
                }
                this.flags |= 8;
                c = this.readChar();
            } else if ((this.flags & 2) != 0) {
                throw new TomlBomException("Source data does not contain a BOM");
            }
        }
        return c;
    }

    @Override
    public void close() throws TomlIOException {
        try {
            super.close();
        }
        catch (IOException e) {
            TomlIOException.rethrow(e);
        }
    }
}

