/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.io.source;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.except.TomlException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.except.TomlIOException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.except.parse.TomlBomException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.io.source.CharSource;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.option.prop.OrderMarkPolicy;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public final class ReaderCharSource
extends FilterReader
implements CharSource {
    private static final int BOM_ALLOWED = 1;
    private static final int BOM_REQUIRED = 2;
    private static final int BOM_CHECKED = 4;
    private static final int BOM_READ = 8;
    private int flags;

    public ReaderCharSource(@NotNull Reader in, @NotNull OrderMarkPolicy bomPolicy) {
        super(in);
        int flags = 0;
        switch (bomPolicy) {
            case ALWAYS: {
                flags |= 2;
            }
            case IF_PRESENT: {
                flags |= 1;
            }
        }
        this.flags = flags;
    }

    public boolean didReadBOM() {
        return (this.flags & 8) != 0;
    }

    private @Range(from=-1L, to=65535L) int readRethrow() throws TomlIOException {
        try {
            return this.in.read();
        }
        catch (IOException e) {
            TomlIOException.rethrow(e);
            return -1;
        }
    }

    @Override
    public @Range(from=-1L, to=65535L) int next() throws TomlException {
        int c = this.readRethrow();
        if ((this.flags & 4) == 0) {
            if (c == 65279) {
                if ((this.flags & 1) == 0) {
                    throw new TomlBomException("Source data contains a BOM");
                }
                this.flags |= 8;
                c = this.readRethrow();
            } else if ((this.flags & 2) != 0) {
                throw new TomlBomException("Source data does not contain a BOM");
            }
        }
        return c;
    }

    @Override
    public void close() throws TomlIOException {
        try {
            super.close();
        }
        catch (IOException e) {
            TomlIOException.rethrow(e);
        }
    }
}

