/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.io.source;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.except.TomlException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.except.parse.TomlLocalParseException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.io.source.CharSource;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public final class BufferedCharSource
implements CharSource {
    private static final int BUFFER_SIZE = 8;
    private final CharSource backing;
    private final char[] buf;
    private int ir;
    private int iw;
    private int ln;
    private int cn;

    public BufferedCharSource(@NotNull CharSource backing) {
        this.backing = backing;
        this.buf = new char[8];
        this.ir = 0;
        this.iw = 0;
        this.ln = 0;
        this.cn = 0;
    }

    public int peek() throws TomlException {
        int c = this.backing.next();
        if (c == -1) {
            return -1;
        }
        int next = (this.iw + 1) % 8;
        if (next == this.ir) {
            throw new AssertionError((Object)"Buffer overflow");
        }
        this.buf[this.iw] = (char)c;
        this.iw = next;
        return c;
    }

    public boolean skipWhitespace() throws TomlException {
        int next;
        do {
            if ((next = this.next()) != -1) continue;
            return false;
        } while (next == 32 || next == 9);
        this.buf[this.iw] = (char)next;
        this.iw = (this.iw + 1) % 8;
        return true;
    }

    @Contract(value="true -> !null")
    @Nullable
    public String finishExpression(boolean comment) throws TomlException {
        int next;
        StringBuilder commentBuffer;
        StringBuilder stringBuilder = commentBuffer = comment ? new StringBuilder() : null;
        while ((next = this.next()) != -1 && next != 10) {
            if (next == 13) {
                int lf = this.next();
                if (lf == 10) break;
                this.raise("Read CR without matching LF");
                break;
            }
            if (comment) {
                if (next == 32 || next == 9) {
                    if (commentBuffer.length() == 0) {
                        continue;
                    }
                } else if (next < 32 || next == 127) {
                    this.raise("Control character (" + next + ") is not allowed in comment");
                }
                commentBuffer.append((char)next);
                continue;
            }
            if (next == 32 || next == 9) continue;
            if (next == 35) {
                comment = true;
                commentBuffer = new StringBuilder();
                continue;
            }
            this.raise("Expected whitespace or comment, got character (" + next + ")");
        }
        return comment ? commentBuffer.toString() : null;
    }

    @Contract(value="_ -> fail")
    public void raise(@NotNull String message) throws TomlLocalParseException {
        throw new TomlLocalParseException(message, this.ln, this.cn);
    }

    @Contract(value="_, _ -> fail")
    public void raise(@NotNull String message, @Nullable Throwable cause) throws TomlLocalParseException {
        throw new TomlLocalParseException(message, cause, this.ln, this.cn);
    }

    @Override
    public @Range(from=-1L, to=65535L) int next() throws TomlException {
        int n;
        if (this.ir != this.iw) {
            n = this.buf[this.ir];
            this.ir = (this.ir + 1) % 8;
        } else {
            n = this.backing.next();
        }
        if (n == 10) {
            ++this.ln;
            this.cn = 0;
        } else {
            ++this.cn;
        }
        return n;
    }

    @Override
    public char nextChar() throws TomlException {
        char n;
        if (this.ir != this.iw) {
            n = this.buf[this.ir];
            this.ir = (this.ir + 1) % 8;
        } else {
            n = this.backing.nextChar();
        }
        if (n == '\n') {
            ++this.ln;
            this.cn = 0;
        } else {
            ++this.cn;
        }
        return n;
    }

    @Override
    public void close() throws TomlException {
        this.backing.close();
    }
}

