/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.io;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.comment.Comments;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.except.TomlException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.except.parse.TomlClobberException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.except.parse.TomlExtensionException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.expression.Expression;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.expression.KeyValueExpression;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.expression.TableExpression;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.io.ExpressionReader;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.io.source.BufferedCharSource;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.key.TomlKey;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.option.JTomlOption;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.option.JTomlOptions;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.FlaggedTomlValue;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.TomlValue;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.array.TomlArray;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.table.TomlTable;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;

public final class TableReader
extends ExpressionReader {
    public TableReader(@NotNull BufferedCharSource in, @NotNull JTomlOptions options) {
        super(in, options);
    }

    @NotNull
    public TomlTable readTable() {
        Expression next;
        TomlTable ret = TomlTable.create();
        Context ctx = new Context(ret, this.options.get(JTomlOption.EXTENSION_GUARD));
        boolean readComments = this.options.get(JTomlOption.READ_COMMENTS);
        LinkedList<String> comments = readComments ? new LinkedList<String>() : null;
        TomlValue commentAttr = ret;
        while ((next = this.readExpression()) != null) {
            String comment;
            TomlValue defined;
            if (next.isKeyValue()) {
                defined = ctx.applyKeyValue(next.asKeyValue());
            } else if (next.isTable()) {
                defined = ctx.applyTable(next.asTable());
            } else {
                if (!readComments || (comment = next.getComment()) == null) continue;
                comments.add(comment);
                continue;
            }
            if (!readComments) continue;
            commentAttr = defined;
            Comments definedComments = defined.comments();
            comment = next.getComment();
            if (comment != null) {
                definedComments.addInline(comment);
            }
            for (String pre : comments) {
                definedComments.addPre(pre);
            }
            comments.clear();
        }
        if (readComments && !comments.isEmpty()) {
            Comments attrComments = commentAttr.comments();
            for (String post : comments) {
                attrComments.addPost(post);
            }
        }
        return ret;
    }

    private static final class Context {
        private final TomlTable global;
        private final boolean extGuard;
        private boolean useSub;
        private TomlKey subKey;
        private TomlTable subTable;

        Context(@NotNull TomlTable global, boolean extGuard) {
            this.global = global;
            this.extGuard = extGuard;
            this.useSub = false;
            this.subKey = null;
            this.subTable = null;
        }

        @NotNull
        TomlTable applyTable(@NotNull TableExpression e) throws TomlException {
            TomlValue existing;
            TomlTable table;
            TomlValue head = this.global;
            TomlKey key = e.key();
            int ks = key.size();
            assert (ks != 0);
            for (int i = 0; i < ks - 1; ++i) {
                TomlValue next;
                TomlKey last = TomlKey.literal((CharSequence[])new String[]{key.get(i)});
                if (head.isTable()) {
                    next = head.asTable().get(last);
                    if (next == null) {
                        next = TomlTable.create();
                        head.asTable().put(last, next);
                    }
                } else if (head.isArray()) {
                    TomlTable tbl;
                    TomlArray arr = head.asArray();
                    int len = arr.size();
                    if (len == 0 || !(next = arr.get(len - 1)).isTable() || FlaggedTomlValue.isConstant(next)) {
                        next = TomlTable.create();
                        arr.add(next);
                    }
                    if ((next = (tbl = next.asTable()).get(last)) == null) {
                        next = TomlTable.create();
                        tbl.put(last, next);
                    }
                } else {
                    throw new TomlClobberException("Defining table \"" + key + "\" would override primitive \"" + key.slice(0, i + 1) + "\"");
                }
                if (this.extGuard && FlaggedTomlValue.isConstant(next)) {
                    throw new TomlExtensionException("Defining table \"" + key + "\" would extend constant value \"" + key.slice(0, i + 1) + "\"");
                }
                head = next;
            }
            if (head.isTable()) {
                table = head.asTable();
            } else if (head.isArray()) {
                TomlValue last;
                TomlArray arr = head.asArray();
                int len = arr.size();
                if (len == 0 || !(last = arr.get(len - 1)).isTable() || FlaggedTomlValue.isConstant(last)) {
                    table = TomlTable.create();
                    arr.add(table);
                } else {
                    table = last.asTable();
                }
            } else {
                throw new TomlClobberException("Defining table at \"" + key + "\" would override primitive at \"" + key.slice(0, ks - 1) + "\"");
            }
            TomlKey name = TomlKey.literal((CharSequence[])new String[]{key.get(ks - 1)});
            TomlTable newTable = TomlTable.create();
            if (e.isArray()) {
                TomlArray array;
                existing = table.get(name);
                if (existing != null) {
                    if (!existing.isArray()) {
                        throw new TomlClobberException("Defining table array \"" + key + "\" would override existing non-array");
                    }
                    if (this.extGuard && FlaggedTomlValue.isConstant(existing)) {
                        throw new TomlExtensionException("Defining table array \"" + key + "\" extends existing constant array");
                    }
                    array = existing.asArray();
                } else {
                    array = TomlArray.create();
                    table.put(name, (TomlValue)array);
                }
                array.add(newTable);
            } else {
                existing = table.get(name);
                if (existing != null) {
                    if (!existing.isTable()) {
                        throw new TomlClobberException("Defining table \"" + key + "\" would override existing non-table");
                    }
                    if (this.extGuard && FlaggedTomlValue.isConstant(existing)) {
                        throw new TomlExtensionException("Defining table \"" + key + "\" extends existing constant table");
                    }
                    if (FlaggedTomlValue.isNonReusable(existing)) {
                        throw new TomlExtensionException("Reuse of explicitly defined table \"" + key + "\"");
                    }
                    newTable = existing.asTable();
                    table.remove(name);
                    FlaggedTomlValue flagged = FlaggedTomlValue.wrap(existing);
                    flagged.setNonReusable(true);
                    table.put(name, (TomlValue)flagged);
                } else {
                    FlaggedTomlValue flagged = FlaggedTomlValue.wrap(newTable);
                    flagged.setNonReusable(true);
                    flagged.setNonKeyExtendable(true);
                    table.put(name, (TomlValue)flagged);
                }
            }
            this.useSub = true;
            this.subTable = newTable;
            this.subKey = key;
            return newTable;
        }

        @NotNull
        TomlValue applyKeyValue(@NotNull KeyValueExpression e) throws TomlException {
            TomlTable target = this.useSub ? this.subTable : this.global;
            TomlKey key = e.key();
            TomlValue value = e.value();
            int kl = key.size();
            for (int i = 0; i < kl - 1; ++i) {
                TomlKey part = TomlKey.literal((CharSequence[])new String[]{key.get(i)});
                TomlValue next = target.get(part);
                if (next == null) {
                    TomlTable sub = TomlTable.create();
                    FlaggedTomlValue flagged = FlaggedTomlValue.wrap(sub);
                    flagged.setNonReusable(true);
                    target.put(part, (TomlValue)flagged);
                    target = sub;
                    continue;
                }
                if (next.isTable()) {
                    if (this.extGuard && FlaggedTomlValue.isConstant(next)) {
                        throw new TomlExtensionException("Defining value \"" + this.fullKey(key) + "\" would extend constant table \"" + this.fullKey(key.slice(0, i + 1)) + "\"");
                    }
                    if (this.extGuard && FlaggedTomlValue.isNonKeyExtendable(next)) {
                        throw new TomlExtensionException("Cannot extend table \"" + this.fullKey(key.slice(0, i + 1)) + "\" (defining key " + this.fullKey(key) + ")");
                    }
                    target = next.asTable();
                    continue;
                }
                throw new TomlClobberException("Defining value \"" + this.fullKey(key) + "\" would override non-table \"" + this.fullKey(key.slice(0, i + 1)) + "\"");
            }
            TomlKey name = TomlKey.literal((CharSequence[])new String[]{key.get(kl - 1)});
            if (target.contains(name)) {
                throw new TomlClobberException("Attempt to re-define \"" + this.fullKey(key) + "\"");
            }
            if (!value.isPrimitive()) {
                FlaggedTomlValue flaggedValue = FlaggedTomlValue.wrap(value);
                flaggedValue.setConstant(true);
                value = flaggedValue;
            }
            target.put(name, value);
            return value;
        }

        @NotNull
        private TomlKey fullKey(@NotNull TomlKey key) {
            return this.useSub ? TomlKey.join(this.subKey, key) : key;
        }
    }
}

