/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.io;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.comment.Comments;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.except.TomlException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.except.parse.TomlDateTimeException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.expression.AbstractExpression;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.expression.EmptyExpression;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.expression.Expression;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.io.source.BufferedCharSource;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.key.TomlKey;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.option.JTomlOption;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.option.JTomlOptions;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.FlaggedTomlValue;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.TomlValue;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.UnsafePrimitives;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.array.TomlArray;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive.TomlPrimitive;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.table.TomlTable;
import java.io.Closeable;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public class ExpressionReader
implements Closeable {
    protected final BufferedCharSource in;
    protected final JTomlOptions options;

    public ExpressionReader(@NotNull BufferedCharSource in, @NotNull JTomlOptions options) {
        this.in = in;
        this.options = options;
    }

    @Nullable
    public Expression readExpression() throws TomlException {
        AbstractExpression ret;
        if (!this.in.skipWhitespace()) {
            return null;
        }
        char c0 = this.in.nextChar();
        if (c0 == '\r') {
            if (this.in.next() != 10) {
                this.in.raise("Carriage return without matching newline");
            }
            return Expression.empty();
        }
        if (c0 == '\n') {
            return Expression.empty();
        }
        if (c0 == '#') {
            EmptyExpression ret2 = Expression.empty();
            ret2.setComment(this.in.finishExpression(true));
            return ret2;
        }
        if (c0 == '[') {
            boolean isArray;
            boolean bl = isArray = this.in.peek() == 91;
            if (isArray) {
                this.in.next();
            }
            if (!this.in.skipWhitespace()) {
                this.in.raise("Incomplete table header");
            }
            TomlKey key = this.readKey(new StringBuilder(), 93, '\u0000');
            if (isArray && this.in.next() != 93) {
                this.in.raise("Missing 2nd closing bracket for array table");
            }
            ret = Expression.table(key, isArray);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(c0);
            TomlKey key = this.readKey(sb, 61, c0 == '\"' || c0 == '\'' ? c0 : (char)'\u0000');
            if (!this.in.skipWhitespace()) {
                this.in.raise("Expected value, got EOF");
            }
            TomlValue value = this.readValue();
            ret = Expression.keyValue(key, value);
        }
        ret.setComment(this.in.finishExpression(false));
        return ret;
    }

    @Override
    public void close() throws TomlException {
        this.in.close();
    }

    @Contract(mutates="this, param1")
    @NotNull
    private TomlKey readKey(@NotNull StringBuilder buf, int terminatedBy, char quot) throws TomlException {
        boolean escaped = false;
        block2: while (true) {
            int next;
            if ((next = this.in.next()) == -1) {
                this.in.raise("Encountered EOF while reading key");
            }
            if (next == 13 || next == 10) {
                this.in.raise("Invalid newline within key");
            }
            if (quot == '\u0000' && next == terminatedBy) {
                this.stripBareWhitespace(buf);
                try {
                    return TomlKey.parse(buf);
                }
                catch (IllegalArgumentException e) {
                    this.in.raise("Invalid key", e);
                }
            }
            char c = (char)next;
            if (escaped) {
                escaped = false;
                buf.append(c);
                int n = c == 'U' ? 8 : (c == 'u' ? 4 : 0);
                int z = 0;
                while (true) {
                    if (z >= n) continue block2;
                    next = this.in.next();
                    if (next == -1) {
                        this.in.raise("Incomplete escape sequence");
                    }
                    buf.append((char)next);
                    ++z;
                }
            }
            if (c == '\\') {
                if (quot == '\"') {
                    escaped = true;
                } else if (quot == '\u0000') {
                    this.in.raise("Disallowed escape sequence");
                }
            } else if (quot == '\u0000') {
                if (c == '\u0000') {
                    this.in.raise("Disallowed NULL character in bare key");
                } else if (c == '\"' || c == '\'') {
                    quot = c;
                } else if (c == ' ' || c == '\t') {
                    c = '\u0000';
                }
            } else if (c == quot) {
                quot = '\u0000';
            }
            buf.append(c);
        }
    }

    private void stripBareWhitespace(@NotNull StringBuilder sb) throws TomlException {
        int trimStart = 0;
        while (true) {
            if (trimStart >= sb.length()) {
                this.in.raise("Empty key");
            }
            if (sb.charAt(trimStart) != '\u0000') break;
            ++trimStart;
        }
        if (trimStart != 0) {
            int rem = sb.length() - trimStart;
            for (int i = 0; i < rem; ++i) {
                sb.setCharAt(i, sb.charAt(trimStart + i));
            }
            sb.setLength(rem);
        }
        trimStart = sb.length();
        while (true) {
            if (sb.charAt(trimStart - 1) != '\u0000') break;
            --trimStart;
        }
        sb.setLength(trimStart);
        int head = 1;
        while (head < sb.length()) {
            int end;
            char c = sb.charAt(head);
            if (c != '\u0000') {
                ++head;
                continue;
            }
            boolean neighbored = sb.charAt(head - 1) == '.';
            for (end = head + 1; end < sb.length(); ++end) {
                c = sb.charAt(end);
                if (c == '\u0000') continue;
                if (c != '.') break;
                neighbored = true;
                break;
            }
            if (!neighbored) {
                this.in.raise("Disallowed whitespace in bare key");
            }
            int rem = sb.length() - end;
            for (int z = 0; z < rem; ++z) {
                sb.setCharAt(head + z, sb.charAt(end + z));
            }
            sb.setLength(head + rem);
        }
    }

    @NotNull
    private TomlValue readValue() throws TomlException {
        return this.readValue(-1);
    }

    @NotNull
    private TomlValue readValue(int firstIfKnown) throws TomlException {
        int len;
        int c0;
        int n = c0 = firstIfKnown != -1 ? (int)firstIfKnown : this.in.nextChar();
        if (c0 == 34) {
            return this.readBasicString();
        }
        if (c0 == 39) {
            return this.readLiteralString();
        }
        if (c0 == 116 || c0 == 102) {
            return this.readBoolean();
        }
        if (c0 == 91) {
            return this.readArray();
        }
        if (c0 == 123) {
            return this.readInlineTable();
        }
        int mode = 0;
        StringBuilder sb = new StringBuilder();
        int next = c0;
        boolean firstChar = true;
        do {
            boolean valid;
            block19: {
                block25: {
                    block26: {
                        block22: {
                            block24: {
                                block23: {
                                    block20: {
                                        block21: {
                                            valid = true;
                                            if (48 <= next && next <= 57 || next == 43 || next == 45 || next == 32 || mode == 2 && (65 <= next && next <= 70 || 97 <= next && next <= 102)) break block19;
                                            if (mode != 0 && mode != 2) break block20;
                                            if (next != 120 && next != 111 && next != 98) break block21;
                                            mode = 2;
                                            break block19;
                                        }
                                        if (next == 95) break block19;
                                    }
                                    if (mode != 0 && mode != 1 && mode != 3) break block22;
                                    if (next != 101 && next != 69 && next != 105 && next != 110 && next != 102 && next != 97) break block23;
                                    mode = 3;
                                    break block19;
                                }
                                if (next != 46) break block24;
                                if (mode == 0) {
                                    mode = 1;
                                }
                                break block19;
                            }
                            if (next == 95) break block19;
                        }
                        if (mode != 0 && mode != 1 && mode != 4) break block25;
                        if (next != 84 && next != 116 && next != 90 && next != 122 && next != 58) break block26;
                        mode = 4;
                        break block19;
                    }
                    if (next == 46) break block19;
                }
                valid = false;
            }
            if (!valid) {
                if (!firstChar) break;
                this.in.raise("Illegal character for primitive value");
                break;
            }
            if (firstChar) {
                sb.append((char)next);
                firstChar = false;
                continue;
            }
            sb.append(this.in.nextChar());
        } while ((next = this.in.peek()) != -1);
        if (mode == 0 && sb.length() > 4 && sb.charAt(4) == '-') {
            mode = 4;
        }
        for (len = sb.length(); len > 0 && sb.charAt(len - 1) == ' '; --len) {
        }
        sb.setLength(len);
        if (mode == 0 || mode == 2) {
            return this.parseInteger(sb);
        }
        if (mode == 1 || mode == 3) {
            return this.parseFloat(sb);
        }
        try {
            return this.parseDateTime(sb);
        }
        catch (DateTimeException e) {
            throw new TomlDateTimeException(e);
        }
    }

    @NotNull
    private TomlPrimitive parseInteger(@NotNull CharSequence str) throws TomlException {
        int len = str.length();
        if (len == 0) {
            this.in.raise("Cannot parse empty sequence as integer");
        }
        long n = 0L;
        int specifier = 0;
        if (len > 2 && str.charAt(0) == '0') {
            specifier = str.charAt(1);
        }
        if (specifier == 120) {
            for (int i = 2; i < len; ++i) {
                int v;
                char d = str.charAt(i);
                if ('0' <= d && d <= '9') {
                    v = d - 48;
                } else if ('A' <= d && d <= 'F') {
                    v = d - 65 + 10;
                } else if ('a' <= d && d <= 'f') {
                    v = d - 97 + 10;
                } else {
                    if (d == '_') {
                        if (i != 2 && i != len - 1 && str.charAt(i - 1) != '_') continue;
                        this.in.raise("Illegal underscore placement");
                        continue;
                    }
                    this.in.raise("Invalid char for hexadecimal integer");
                    break;
                }
                if (Long.numberOfLeadingZeros(n) < 4) {
                    this.in.raise("Integer is too large");
                }
                n = n << 4 | (long)v;
            }
        } else if (specifier == 111) {
            for (int i = 2; i < len; ++i) {
                char d = str.charAt(i);
                if ('0' > d || d > '7') {
                    if (d == '_') {
                        if (i != 2 && i != len - 1 && str.charAt(i - 1) != '_') continue;
                        this.in.raise("Illegal underscore placement");
                        continue;
                    }
                    this.in.raise("Invalid char for octal integer");
                    break;
                }
                int v = d - 48;
                if (Long.numberOfLeadingZeros(n) < 3) {
                    this.in.raise("Integer is too large");
                }
                n = n << 3 | (long)v;
            }
        } else if (specifier == 98) {
            for (int i = 2; i < len; ++i) {
                int v;
                char d = str.charAt(i);
                if (d == '0') {
                    v = 0;
                } else if (d == '1') {
                    v = 1;
                } else {
                    if (d == '_') {
                        if (i != 2 && i != len - 1 && str.charAt(i - 1) != '_') continue;
                        this.in.raise("Illegal underscore placement");
                        continue;
                    }
                    this.in.raise("Invalid char for binary integer");
                    break;
                }
                if ((n & Long.MIN_VALUE) != 0L) {
                    this.in.raise("Integer is too large");
                }
                n = n << 1 | (long)v;
            }
        } else {
            boolean negative = false;
            int start = 0;
            char d = str.charAt(0);
            if (d == '+') {
                start = 1;
            } else if (d == '-') {
                negative = true;
                start = 1;
            }
            if (start == len) {
                this.in.raise("Expected decimal digits after sign");
            }
            for (int i = start; i < len; ++i) {
                int v;
                d = str.charAt(i);
                if (d == '0') {
                    if (i == start && i != len - 1) {
                        this.in.raise("Disallowed leading 0 in decimal integer");
                    }
                    v = 0;
                } else if ('0' < d && d <= '9') {
                    v = d - 48;
                } else {
                    if (d == '_') {
                        if (i != start && i != len - 1 && str.charAt(i - 1) != '_') continue;
                        this.in.raise("Illegal underscore placement");
                        continue;
                    }
                    this.in.raise("Invalid char for decimal integer");
                    break;
                }
                try {
                    n = Math.multiplyExact(n, 10);
                    n = Math.addExact(n, negative ? (long)(-v) : (long)v);
                    continue;
                }
                catch (ArithmeticException e) {
                    this.in.raise("Integer is too large", e);
                }
            }
        }
        return TomlPrimitive.of(n);
    }

    @NotNull
    private TomlPrimitive parseFloat(@NotNull CharSequence str) throws TomlException {
        double d;
        long exp;
        double frac;
        long ip;
        int head;
        boolean negative;
        int len;
        block39: {
            boolean leadsWithZero;
            int rem;
            len = str.length();
            if (len == 0) {
                this.in.raise("Cannot parse empty sequence as float");
            }
            negative = false;
            head = 0;
            char c = str.charAt(0);
            if (c == '+') {
                head = 1;
            } else if (c == '-') {
                negative = true;
                head = 1;
            }
            if (head == len) {
                this.in.raise("Expected float after sign");
            }
            if ((rem = len - head) == 3) {
                char c0 = str.charAt(head);
                char c1 = str.charAt(head + 1);
                char c2 = str.charAt(head + 2);
                if (c0 == 'i' && c1 == 'n' && c2 == 'f') {
                    return negative ? UnsafePrimitives.createFloat(Double.NEGATIVE_INFINITY, "-inf") : UnsafePrimitives.createFloat(Double.POSITIVE_INFINITY, "inf");
                }
                if (c0 == 'n' && c1 == 'a' && c2 == 'n') {
                    return UnsafePrimitives.createFloat(Double.NaN, "nan");
                }
            }
            if ((c = str.charAt(head++)) == '0') {
                leadsWithZero = true;
                ip = 0L;
            } else {
                if (c < '1' || c > '9') {
                    this.in.raise("Invalid integer part");
                }
                leadsWithZero = false;
                ip = c - 48;
            }
            while (head < len) {
                c = str.charAt(head);
                if (c == '_') {
                    if (++head < len && (c = str.charAt(head)) >= '0' && c <= '9') continue;
                    this.in.raise("Illegal underscore placement");
                    continue;
                }
                if (c < '0' || c > '9') break;
                if (leadsWithZero) {
                    this.in.raise("Illegal leading zero in float");
                }
                ++head;
                try {
                    ip = Math.multiplyExact(ip, 10);
                    ip = Math.addExact(ip, (long)(c - 48));
                }
                catch (ArithmeticException e) {
                    this.in.raise("Integer part is too large", e);
                }
            }
            if (head >= len) {
                this.in.raise("Expected decimal point or exponent");
            }
            frac = 0.0;
            exp = 0L;
            boolean none = true;
            if ((c = str.charAt(head++)) == '.') {
                StringBuilder buf = new StringBuilder("0.");
                none = false;
                if (head >= len) {
                    this.in.raise("Expected digits after decimal point");
                }
                if ((c = str.charAt(head++)) < '0' || c > '9') {
                    this.in.raise("Invalid fractional part");
                }
                buf.append(c);
                while (head < len) {
                    if ((c = str.charAt(head++)) == '_') {
                        if (head < len && (c = str.charAt(head)) >= '0' && c <= '9') continue;
                        this.in.raise("Illegal underscore placement");
                        continue;
                    }
                    if (c < '0' || c > '9') break;
                    buf.append(c);
                }
                frac = Double.parseDouble(buf.toString());
            }
            if (c == 'e' || c == 'E') {
                boolean exponentNegative = false;
                if (head >= len) {
                    this.in.raise("Expected decimal after exponent");
                }
                if ((c = str.charAt(head++)) == '+') {
                    if (head >= len) {
                        this.in.raise("Expected digits after sign");
                    }
                    c = str.charAt(head++);
                } else if (c == '-') {
                    if (head >= len) {
                        this.in.raise("Expected digits after sign");
                    }
                    c = str.charAt(head++);
                    exponentNegative = true;
                }
                boolean first = true;
                while (true) {
                    if (c == '_') {
                        if (!first && head < len && (c = str.charAt(head++)) >= '0' && c <= '9') continue;
                        this.in.raise("Illegal underscore placement");
                        continue;
                    }
                    first = false;
                    if (c < '0' || c > '9') break block39;
                    try {
                        exp = Math.multiplyExact(exp, 10);
                        exp = Math.addExact(exp, exponentNegative ? (long)(48 - c) : (long)(c - 48));
                    }
                    catch (ArithmeticException e) {
                        this.in.raise("Exponent is too large", e);
                    }
                    if (head < len) {
                        c = str.charAt(head++);
                        continue;
                    }
                    break block39;
                    break;
                }
            }
            if (none) {
                this.in.raise("Expected decimal point or exponent");
            }
        }
        if (head < len) {
            this.in.raise("Unprocessable characters in float");
        }
        if (exp != 0L) {
            double scale = Math.pow(10.0, exp);
            d = scale * (double)ip + scale * frac;
        } else {
            d = (double)ip + frac;
        }
        if (negative) {
            d = -d;
        }
        return UnsafePrimitives.createFloat(d, str.toString());
    }

    @NotNull
    private TomlPrimitive parseDateTime(@NotNull CharSequence str) throws TomlException, DateTimeException {
        ZoneOffset offset;
        int len = str.length();
        if (len < 8) {
            this.in.raise("Datetime sequence is too short");
        }
        if (str.charAt(2) == ':') {
            return TomlPrimitive.of(this.parsePartialTime(str, 0, len), this.options.get(JTomlOption.TIME_ZONE));
        }
        if (len < 10 || str.charAt(4) != '-' || str.charAt(7) != '-') {
            this.in.raise("Invalid date");
        }
        int year = this.parseNDigits(str, 0, 4);
        int month = this.parseNDigits(str, 5, 2);
        int day = this.parseNDigits(str, 8, 2);
        if (month < 1 || month > 12) {
            this.in.raise("Month out of range (got " + month + ")");
        }
        if (day < 1 || day > 31) {
            this.in.raise("Day out of range (got " + day + ")");
        }
        LocalDate date = LocalDate.of(year, month, day);
        if (len == 10) {
            return TomlPrimitive.of(date, this.options.get(JTomlOption.TIME_ZONE));
        }
        char delim = str.charAt(10);
        if (delim != 'T' && delim != 't' && delim != ' ') {
            this.in.raise("Expected time delimiter");
        }
        int whereOffset = -1;
        boolean numOffset = false;
        for (int i = 11; i < len; ++i) {
            char c = str.charAt(i);
            if (c == 'Z' || c == 'z') {
                whereOffset = i;
                break;
            }
            if (c != '+' && c != '-') continue;
            whereOffset = i;
            numOffset = true;
            break;
        }
        if (whereOffset == -1) {
            LocalTime time = this.parsePartialTime(str, 11, len - 11);
            return TomlPrimitive.of(LocalDateTime.of(date, time), this.options.get(JTomlOption.TIME_ZONE));
        }
        LocalTime time = this.parsePartialTime(str, 11, whereOffset - 11);
        LocalDateTime dateTime = LocalDateTime.of(date, time);
        if (numOffset) {
            boolean negative;
            int rem = len - whereOffset;
            if (rem < 6 || !(negative = str.charAt(whereOffset) == '-') && str.charAt(whereOffset) != '+') {
                this.in.raise("Invalid time offset");
                return null;
            }
            int hour = this.parseNDigits(str, whereOffset + 1, 2);
            int minute = this.parseNDigits(str, whereOffset + 4, 2);
            if (negative) {
                hour = -hour;
            }
            if (hour < -18 || hour > 18) {
                this.in.raise("Offset hour out of range (got " + hour + ")");
            }
            if (minute < 0 || minute > 59) {
                this.in.raise("Offset minute out of range (got " + minute + ")");
            }
            offset = ZoneOffset.ofHoursMinutes(hour, hour < 0 ? -minute : minute);
        } else {
            offset = ZoneOffset.UTC;
        }
        return TomlPrimitive.of(dateTime.atOffset(offset));
    }

    @NotNull
    private LocalTime parsePartialTime(@NotNull CharSequence str, int off, int len) throws TomlException {
        if (len < 8) {
            this.in.raise("Partial time sequence is too short");
        }
        if (str.charAt(off + 2) != ':' || str.charAt(off + 5) != ':') {
            this.in.raise("Missing time separator(s)");
        }
        int hour = this.parseNDigits(str, off, 2);
        int minute = this.parseNDigits(str, off + 3, 2);
        int second = this.parseNDigits(str, off + 6, 2);
        if (hour < 0 || hour > 23) {
            this.in.raise("Hour out of range (got " + hour + ")");
        }
        if (minute < 0 || minute > 59) {
            this.in.raise("Minute out of range (got " + minute + ")");
        }
        if (second < 0 || second > 59) {
            this.in.raise("Minute out of range (got " + second + ")");
        }
        int nanos = 0;
        if (len > 8) {
            int nd;
            char c = str.charAt(off + 8);
            if (c != '.') {
                this.in.raise("Expected decimal point");
            }
            if (len < 10) {
                this.in.raise("Expected digits after decimal point");
            }
            if ((nd = len - 9) <= 9) {
                nanos = this.parseNDigits(str, off + 9, nd);
                switch (nd) {
                    case 1: {
                        nanos *= 100000000;
                        break;
                    }
                    case 2: {
                        nanos *= 10000000;
                        break;
                    }
                    case 3: {
                        nanos *= 1000000;
                        break;
                    }
                    case 4: {
                        nanos *= 100000;
                        break;
                    }
                    case 5: {
                        nanos *= 10000;
                        break;
                    }
                    case 6: {
                        nanos *= 1000;
                        break;
                    }
                    case 7: {
                        nanos *= 100;
                        break;
                    }
                    case 8: {
                        nanos *= 10;
                    }
                }
            } else {
                nanos = this.parseNDigits(str, off + 9, 9);
                for (int i = 18; i < len; ++i) {
                    c = str.charAt(off + i);
                    if (c >= '0' && c <= '9') continue;
                    this.in.raise("Expected digit");
                }
            }
        }
        return LocalTime.of(hour, minute, second, nanos);
    }

    private int parseNDigits(@NotNull CharSequence str, int off, int len) throws TomlException {
        int d = 0;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(off + i);
            if (c < '0' || c > '9') {
                this.in.raise("Invalid n-digit value");
            }
            d = d * 10 + (c - 48);
        }
        return d;
    }

    private int openString(char quot) throws TomlException {
        int p1;
        int p0 = this.in.peek();
        if (p0 == -1) {
            this.in.raise("Unclosed string");
        }
        if ((p1 = this.in.peek()) == -1) {
            if (p0 != quot) {
                this.in.raise("Unclosed string");
            }
            return 0;
        }
        if (p0 == quot && p1 == quot) {
            this.in.next();
            this.in.next();
            return 2;
        }
        return 1;
    }

    @NotNull
    private TomlPrimitive readBasicString() throws TomlException {
        switch (this.openString('\"')) {
            case 0: {
                return TomlPrimitive.of("");
            }
            case 2: {
                return this.readMultilineBasicString();
            }
        }
        StringBuilder sb = new StringBuilder();
        while (true) {
            int next;
            if ((next = this.in.next()) == -1) {
                this.in.raise("Unclosed basic string");
            }
            if (next == 92) {
                this.readEscapeSequence(sb);
                continue;
            }
            if (next == 34) {
                return TomlPrimitive.of(sb.toString());
            }
            if (next < 32 && next != 9 || next == 127) {
                this.in.raise("Disallowed control character in basic string");
            }
            sb.append((char)next);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private TomlPrimitive readMultilineBasicString() throws TomlException {
        StringBuilder sb = new StringBuilder();
        int next = this.in.next();
        if (next == 13) {
            if (this.in.next() != 10) {
                this.in.raise("Carriage return without matching line feed");
            }
            next = this.in.next();
        } else if (next == 10) {
            next = this.in.next();
        }
        boolean trimming = false;
        while (true) {
            block29: {
                block33: {
                    int pk;
                    block32: {
                        block31: {
                            block30: {
                                if (next == -1) {
                                    this.in.raise("Unclosed basic string");
                                }
                                if (next != 13) break block30;
                                next = this.in.next();
                                if (next != 10) {
                                    this.in.raise("Carriage return without matching line feed");
                                }
                                if (!trimming) {
                                    sb.append(this.options.get(JTomlOption.LINE_SEPARATOR));
                                }
                                break block29;
                            }
                            if (next != 10) break block31;
                            if (!trimming) {
                                sb.append(this.options.get(JTomlOption.LINE_SEPARATOR));
                            }
                            break block29;
                        }
                        if (next != 92) break block32;
                        trimming = false;
                        pk = this.in.peek();
                        while (pk == 9 || pk == 32) {
                            trimming = true;
                            this.in.next();
                            pk = this.in.peek();
                        }
                        if (pk == 13) {
                            trimming = true;
                            this.in.next();
                            pk = this.in.next();
                            if (pk != 10) {
                                this.in.raise("Carriage return without matching line feed");
                            }
                        } else if (pk == 10) {
                            trimming = true;
                            this.in.next();
                        } else if (trimming) {
                            this.in.raise("Dangling escape character in multiline basic string");
                        }
                        if (!trimming) {
                            this.readEscapeSequence(sb);
                        }
                        break block29;
                    }
                    if (next != 34) break block33;
                    pk = this.in.peek();
                    if (pk != 34) {
                        sb.append((char)next);
                        break block29;
                    } else {
                        this.in.next();
                        pk = this.in.peek();
                        if (pk != 34) {
                            sb.append("\"\"");
                            break block29;
                        } else {
                            this.in.next();
                            int extra = 0;
                            while (true) {
                                if (this.in.peek() != 34) {
                                    return TomlPrimitive.of(sb.toString());
                                }
                                this.in.next();
                                if (++extra == 3) {
                                    this.in.raise("Too many closing quotes for multiline basic string");
                                }
                                sb.append('\"');
                            }
                        }
                    }
                }
                if (next == 32 || next == 9) {
                    if (!trimming) {
                        sb.append((char)next);
                    }
                } else if (next < 32 || next == 127) {
                    this.in.raise("Disallowed control character in basic string");
                } else {
                    trimming = false;
                    sb.append((char)next);
                }
            }
            next = this.in.next();
        }
    }

    private void readEscapeSequence(@NotNull StringBuilder dest) throws TomlException {
        int c = this.in.next();
        if (c == -1) {
            this.in.raise("Truncated escape sequence");
        }
        int uc = 4;
        switch (c) {
            case 34: {
                dest.append('\"');
                break;
            }
            case 92: {
                dest.append('\\');
                break;
            }
            case 98: {
                dest.append('\b');
                break;
            }
            case 102: {
                dest.append('\f');
                break;
            }
            case 110: {
                dest.append('\n');
                break;
            }
            case 114: {
                dest.append('\r');
                break;
            }
            case 116: {
                dest.append('\t');
                break;
            }
            case 85: {
                uc = 8;
            }
            case 117: {
                int v = 0;
                for (int i = 0; i < uc; ++i) {
                    int n;
                    c = this.in.next();
                    if (c == -1) {
                        this.in.raise("Truncated unicode escape sequence");
                    }
                    if ((n = Character.digit(c, 16)) == -1) {
                        this.in.raise("Invalid character in unicode escape sequence");
                    }
                    v = v << 4 | n;
                }
                if (55296 <= v && v <= 57343) {
                    this.in.raise("Non-scalar unicode codepoint");
                }
                if (uc == 8) {
                    try {
                        dest.append(Character.toChars(v));
                    }
                    catch (IllegalArgumentException e) {
                        this.in.raise("Invalid unicode codepoint", e);
                    }
                    break;
                }
                dest.append((char)v);
                break;
            }
            default: {
                this.in.raise("Invalid escape sequence character");
            }
        }
    }

    @NotNull
    private TomlPrimitive readLiteralString() throws TomlException {
        switch (this.openString('\'')) {
            case 0: {
                return TomlPrimitive.of("");
            }
            case 2: {
                return this.readMultilineLiteralString();
            }
        }
        StringBuilder sb = new StringBuilder();
        while (true) {
            int next;
            if ((next = this.in.next()) == -1) {
                this.in.raise("Unclosed literal string");
            }
            if (next == 39) {
                return TomlPrimitive.of(sb.toString());
            }
            if (next < 32 && next != 9 || next == 127) {
                this.in.raise("Disallowed control character in literal string");
            }
            sb.append((char)next);
        }
    }

    @NotNull
    private TomlPrimitive readMultilineLiteralString() throws TomlException {
        StringBuilder sb = new StringBuilder();
        int next = this.in.next();
        if (next == 13) {
            if (this.in.next() != 10) {
                this.in.raise("Carriage return without matching line feed");
            }
            next = this.in.next();
        } else if (next == 10) {
            next = this.in.next();
        }
        while (true) {
            if (next == -1) {
                this.in.raise("Unclosed literal string");
            }
            if (next == 13) {
                next = this.in.next();
                if (next != 10) {
                    this.in.raise("Carriage return without matching line feed");
                }
                sb.append(this.options.get(JTomlOption.LINE_SEPARATOR));
            } else if (next == 10) {
                sb.append(this.options.get(JTomlOption.LINE_SEPARATOR));
            } else if (next < 32 && next != 9 || next == 127) {
                this.in.raise("Disallowed control character in literal string");
            } else {
                int cl;
                sb.append((char)next);
                if (next == 39 && (cl = sb.length()) >= 3 && sb.charAt(cl - 2) == '\'' && sb.charAt(cl - 3) == '\'') {
                    sb.setLength(cl - 3);
                    int extra = 0;
                    while (this.in.peek() == 39) {
                        this.in.next();
                        if (++extra == 3) {
                            this.in.raise("Too many closing quotes for multiline literal string");
                        }
                        sb.append('\'');
                    }
                    return TomlPrimitive.of(sb.toString());
                }
            }
            next = this.in.next();
        }
    }

    @NotNull
    private TomlPrimitive readBoolean() throws TomlException {
        char[] n3 = new char[3];
        if (this.in.next(n3) == 3) {
            if (n3[0] == 'r' && n3[1] == 'u' && n3[2] == 'e') {
                return TomlPrimitive.of(true);
            }
            if (n3[0] == 'a' && n3[1] == 'l' && n3[2] == 's' && this.in.next() == 101) {
                return TomlPrimitive.of(false);
            }
        }
        this.in.raise("Illegal boolean value");
        return null;
    }

    @NotNull
    private TomlTable readInlineTable() throws TomlException {
        TomlTable ret = TomlTable.create();
        boolean expectComma = false;
        while (true) {
            char c;
            if (!this.in.skipWhitespace()) {
                this.in.raise("Unclosed inline table");
            }
            if ((c = this.in.nextChar()) == '}') {
                return ret;
            }
            if (expectComma) {
                if (c != ',') {
                    this.in.raise("Expected inline table separator or closing char");
                }
                if (!this.in.skipWhitespace()) {
                    this.in.raise("Unclosed inline table");
                }
                if ((c = this.in.nextChar()) == '}') {
                    this.in.raise("Disallowed trailing comma in inline table");
                }
            }
            StringBuilder sb = new StringBuilder();
            sb.append(c);
            TomlKey key = this.readKey(sb, 61, c == '\"' || c == '\'' ? c : (char)'\u0000');
            for (int z = 1; z < key.size() + 1; ++z) {
                TomlKey partialKey = key.slice(0, z);
                TomlValue existing = ret.get(partialKey);
                if (existing == null || !FlaggedTomlValue.isConstant(existing)) continue;
                this.in.raise(key + " conflicts with previously defined key " + partialKey + " in inline table");
            }
            if (!this.in.skipWhitespace()) {
                this.in.raise("Expected value, got EOF");
            }
            TomlValue value = this.readValue();
            FlaggedTomlValue flaggedValue = FlaggedTomlValue.wrap(value);
            flaggedValue.setConstant(true);
            ret.put(key, (TomlValue)flaggedValue);
            expectComma = true;
        }
    }

    @NotNull
    private TomlArray readArray() throws TomlException {
        boolean readComma;
        boolean readComments = this.options.get(JTomlOption.READ_COMMENTS);
        TomlArray ret = TomlArray.create();
        ArrayControl ctrl = this.readArrayControl(readComments);
        if (ctrl.character == ',') {
            this.in.raise("Comma precedes array values");
        }
        if (ctrl.character == ']') {
            return ret;
        }
        while (true) {
            TomlValue next = this.readValue(ctrl.character);
            if (readComments) {
                Comments nextComments = next.comments();
                for (String pre : ctrl.comments) {
                    nextComments.addPre(pre);
                }
            }
            ret.add(next);
            ctrl = this.readArrayControl(readComments);
            if (ctrl.character == ',') {
                readComma = true;
                ctrl = this.readArrayControl(readComments);
                if (ctrl.character == ',') {
                    this.in.raise("Double comma in array");
                }
            } else {
                readComma = false;
            }
            if (ctrl.character == ']') break;
            if (readComma) continue;
            this.in.raise("Missing array separator");
        }
        if (readComma && !ctrl.comments.isEmpty()) {
            TomlValue last = ret.get(ret.size() - 1);
            Comments lastComments = last.comments();
            for (String post : ctrl.comments) {
                lastComments.addPost(post);
            }
        }
        return ret;
    }

    @NotNull
    private ArrayControl readArrayControl(boolean readComments) throws TomlException {
        LinkedList<String> comments = readComments ? new LinkedList<String>() : null;
        StringBuilder commentBuffer = readComments ? new StringBuilder() : null;
        boolean inComment = false;
        while (true) {
            int next;
            if ((next = this.in.next()) == -1) {
                this.in.raise("Unclosed array");
            }
            if (next == 13 && (next = this.in.next()) != 10) {
                this.in.raise("Carriage return without matching newline");
            }
            if (next == 10) {
                if (readComments && inComment) {
                    comments.add(commentBuffer.toString());
                    commentBuffer.setLength(0);
                }
                inComment = false;
                continue;
            }
            if (next == 35) {
                inComment = true;
                continue;
            }
            if (next == 32 || next == 9) {
                if (!readComments || !inComment || commentBuffer.length() == 0) continue;
                commentBuffer.append((char)next);
                continue;
            }
            if (!inComment) {
                return new ArrayControl((char)next, comments);
            }
            if (next < 32 || next == 127) {
                this.in.raise("Disallowed control character in comment");
            }
            if (!readComments) continue;
            commentBuffer.append((char)next);
        }
    }

    private static final class ArrayControl {
        final char character;
        final List<String> comments;

        ArrayControl(char character, @UnknownNullability List<String> comments) {
            this.character = character;
            this.comments = comments;
        }
    }
}

