/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.comment;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.comment.Comment;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.comment.CommentPosition;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.comment.Comments;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
final class CommentsImpl
implements Comments {
    private Comment[] array;
    private int capacity;
    private int preHead;
    private int postHead;
    private boolean hasInline;

    @Contract(value="_ -> new")
    @NotNull
    static CommentsImpl copyOf(@NotNull Comments other) {
        if (other instanceof CommentsImpl) {
            return new CommentsImpl((CommentsImpl)other);
        }
        CommentsImpl ret = new CommentsImpl();
        for (Comment c : other.all()) {
            ret.add(c);
        }
        return ret;
    }

    private CommentsImpl(@NotNull CommentsImpl other) {
        int capacity = other.capacity;
        this.array = new Comment[capacity];
        this.capacity = capacity;
        this.preHead = other.preHead;
        this.postHead = other.postHead;
        this.hasInline = other.hasInline;
        System.arraycopy(other.array, 0, this.array, 0, other.postHead);
    }

    CommentsImpl() {
        this.clear();
    }

    @Override
    public int count() {
        return this.postHead;
    }

    @Override
    @NotNull
    public @Unmodifiable List<Comment> all() {
        return Collections.unmodifiableList(Arrays.asList(this.array).subList(0, this.postHead));
    }

    @Override
    @NotNull
    public @Unmodifiable List<Comment> get(@NotNull CommentPosition position) {
        switch (position) {
            case PRE: {
                return Collections.unmodifiableList(Arrays.asList(this.array).subList(0, this.preHead));
            }
            case INLINE: {
                if (!this.hasInline) {
                    return Collections.emptyList();
                }
                return Collections.singletonList(this.array[this.preHead]);
            }
            case POST: {
                int start = this.preHead;
                if (this.hasInline) {
                    ++start;
                }
                return Collections.unmodifiableList(Arrays.asList(this.array).subList(start, this.postHead));
            }
        }
        throw new AssertionError((Object)"Unreachable code");
    }

    @Override
    public void clear() {
        this.array = new Comment[0];
        this.capacity = 0;
        this.preHead = 0;
        this.postHead = 0;
        this.hasInline = false;
    }

    @Override
    public void clear(@NotNull CommentPosition position) {
        switch (position) {
            case PRE: {
                int tmp = this.preHead;
                System.arraycopy(this.array, tmp, this.array, 0, this.postHead - tmp);
                this.preHead = 0;
                this.postHead -= tmp;
                break;
            }
            case INLINE: {
                if (!this.hasInline) {
                    return;
                }
                int tmp = this.preHead + 1;
                System.arraycopy(this.array, tmp, this.array, this.preHead, this.postHead - tmp);
                this.hasInline = false;
                --this.postHead;
                break;
            }
            case POST: {
                int tmp = this.preHead;
                if (this.hasInline) {
                    ++tmp;
                }
                this.postHead = tmp;
            }
        }
        this.tryShrink();
    }

    @Override
    public void add(@NotNull Comment comment) {
        switch (comment.position()) {
            case PRE: {
                this.ensureCapacity();
                System.arraycopy(this.array, this.preHead, this.array, this.preHead + 1, this.postHead - this.preHead);
                this.array[this.preHead++] = comment;
                ++this.postHead;
                break;
            }
            case INLINE: {
                if (!this.hasInline) {
                    this.ensureCapacity();
                    System.arraycopy(this.array, this.preHead, this.array, this.preHead + 1, this.postHead - this.preHead);
                    this.hasInline = true;
                    ++this.postHead;
                }
                this.array[this.preHead] = comment;
                break;
            }
            case POST: {
                this.ensureCapacity();
                this.array[this.postHead++] = comment;
            }
        }
    }

    private void ensureCapacity() {
        int capacity = this.capacity;
        if (capacity == 0) {
            this.array = new Comment[1];
            this.capacity = 1;
        } else {
            int required = this.postHead + 1;
            if (required <= capacity) {
                return;
            }
            while (required > (capacity <<= 1)) {
            }
            Comment[] cpy = new Comment[capacity];
            System.arraycopy(this.array, 0, cpy, 0, this.postHead);
            this.array = cpy;
            this.capacity = capacity;
        }
    }

    private void tryShrink() {
        int cc;
        int tc = this.capacity;
        boolean any = false;
        while ((cc = tc >> 1) >= this.postHead) {
            tc = cc;
            any = true;
        }
        if (!any) {
            return;
        }
        Comment[] shrink = new Comment[tc];
        System.arraycopy(this.array, 0, shrink, 0, this.postHead);
        this.array = shrink;
        this.capacity = tc;
    }

    public int hashCode() {
        int h = 7;
        for (int i = 0; i < this.postHead; ++i) {
            h = 31 * h + Objects.hashCode(this.array[i]);
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CommentsImpl)) {
            return false;
        }
        CommentsImpl other = (CommentsImpl)obj;
        if (this.postHead != other.postHead) {
            return false;
        }
        for (int i = 0; i < this.postHead; ++i) {
            if (Objects.equals(this.array[i], other.array[i])) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String toString() {
        StringJoiner sj = new StringJoiner(", ");
        for (int i = 0; i < this.postHead; ++i) {
            sj.add(this.array[i].toString());
        }
        return "Comments[" + sj + "]";
    }
}

