/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.comment;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.comment.Comment;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.comment.CommentPosition;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.comment.CommentsImpl;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.NonExtendable
@ApiStatus.AvailableSince(value="0.6.0")
public interface Comments {
    @Contract(value="-> new")
    @NotNull
    public static Comments empty() {
        return new CommentsImpl();
    }

    @Contract(value="_ -> new")
    @ApiStatus.AvailableSince(value="0.6.4")
    @NotNull
    public static Comments copyOf(@NotNull Comments other) {
        return CommentsImpl.copyOf(other);
    }

    public int count();

    @NotNull
    public @Unmodifiable List<Comment> all();

    @NotNull
    public @Unmodifiable List<Comment> get(@NotNull CommentPosition var1);

    @Nullable
    default public String getInline() {
        List<Comment> list = this.get(CommentPosition.INLINE);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0).content();
    }

    public void clear();

    public void clear(@NotNull CommentPosition var1);

    public void add(@NotNull Comment var1);

    default public void add(@NotNull CommentPosition position, @NotNull String content) {
        this.add(Comment.of(position, content));
    }

    default public void addPre(@NotNull String content) {
        this.add(CommentPosition.PRE, content);
    }

    default public void addInline(@NotNull String content) {
        this.add(CommentPosition.INLINE, content);
    }

    default public void setInline(@Nullable String content) {
        if (content == null) {
            this.clear(CommentPosition.INLINE);
        } else {
            this.add(CommentPosition.INLINE, content);
        }
    }

    default public void addPost(@NotNull String content) {
        this.add(CommentPosition.POST, content);
    }
}

