/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.comment;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.comment.Comment;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.comment.CommentPosition;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
final class CommentImpl
implements Comment {
    private final CommentPosition position;
    private final String content;

    private static void checkForInvalidChars(@NotNull String content) {
        int len = content.length();
        for (int i = 0; i < len; ++i) {
            char c = content.charAt(i);
            if (c >= ' ' || c == '\t') continue;
            throw new IllegalArgumentException("Illegal character \\x" + (c >= '\u0010' ? (char)'1' : '0') + Character.forDigit(c & 0xF, 16) + " @ offset " + i);
        }
    }

    CommentImpl(@NotNull CommentPosition position, @NotNull String content) {
        CommentImpl.checkForInvalidChars(content);
        this.position = position;
        this.content = content;
    }

    @Override
    @NotNull
    public CommentPosition position() {
        return this.position;
    }

    @Override
    @NotNull
    public String content() {
        return this.content;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.position, this.content});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CommentImpl)) {
            return false;
        }
        CommentImpl other = (CommentImpl)obj;
        return this.position == other.position && this.content.equals(other.content);
    }

    @NotNull
    public String toString() {
        return "Comment[position=" + this.position.name() + ", content=" + this.content + "]";
    }
}

