/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.comment;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.comment.CommentImpl;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.comment.CommentPosition;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.comment.MultiComment;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@ApiStatus.NonExtendable
@ApiStatus.AvailableSince(value="0.6.0")
public interface Comment {
    @Contract(value="_, _ -> new")
    @NotNull
    public static Comment of(@NotNull CommentPosition position, @NotNull String content) {
        return new CommentImpl(position, content);
    }

    @NotNull
    public CommentPosition position();

    @NotNull
    public String content();

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD, ElementType.TYPE})
    @Repeatable(value=MultiComment.Post.class)
    public static @interface Post {
        @NotNull
        @Pattern(value="^[^\\x00-\\x08\\x0A-\\x1F\\x7F]*$")
        public String value();
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD, ElementType.TYPE})
    @Repeatable(value=MultiComment.Inline.class)
    public static @interface Inline {
        @NotNull
        @Pattern(value="^[^\\x00-\\x08\\x0A-\\x1F\\x7F]*$")
        public String value();
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD, ElementType.TYPE})
    @Repeatable(value=MultiComment.Pre.class)
    public static @interface Pre {
        @NotNull
        @Pattern(value="^[^\\x00-\\x08\\x0A-\\x1F\\x7F]*$")
        public String value();
    }
}

