/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.JToml;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.document.TomlDocument;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.document.TomlDocumentImpl;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.except.TomlException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.except.TomlIOException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.io.TableReader;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.io.TableWriter;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.io.source.BufferedCharSource;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.io.source.ReaderCharSource;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.io.source.StreamCharSource;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.io.source.StringCharSource;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.io.target.CharTarget;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.io.target.StringCharTarget;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.io.target.WriterCharTarget;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.option.JTomlOption;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.option.JTomlOptions;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.option.prop.OrderMarkPolicy;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.serial.TomlSerializer;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.serial.TomlSerializerService;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.table.TomlTable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ServiceLoader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
final class JTomlImpl
implements JToml {
    private static final ServiceLoader<TomlSerializerService> SERIALIZERS;
    private final JTomlOptions options;

    JTomlImpl(@NotNull JTomlOptions options) {
        this.options = options;
    }

    @NotNull
    private TomlTable read(@NotNull BufferedCharSource cs) throws TomlException {
        TableReader tr = new TableReader(cs, this.options);
        return tr.readTable();
    }

    @Override
    @NotNull
    public TomlDocument readFromString(@NotNull String toml) throws TomlException {
        try (StringCharSource cs = new StringCharSource(toml);){
            TomlTable table = this.read(new BufferedCharSource(cs));
            TomlDocumentImpl tomlDocumentImpl = new TomlDocumentImpl(table);
            return tomlDocumentImpl;
        }
    }

    @Override
    @NotNull
    public TomlDocument read(@NotNull InputStream in) throws TomlException {
        StreamCharSource cs = new StreamCharSource(in, this.options.get(JTomlOption.READ_BOM));
        TomlTable table = this.read(new BufferedCharSource(cs));
        TomlDocumentImpl doc = new TomlDocumentImpl(table);
        doc.setOrderMarked(cs.didReadBOM());
        return doc;
    }

    @Override
    @NotNull
    public TomlDocument read(@NotNull Reader reader) throws TomlException {
        ReaderCharSource cs = new ReaderCharSource(reader, this.options.get(JTomlOption.READ_BOM));
        TomlTable table = this.read(new BufferedCharSource(cs));
        TomlDocumentImpl doc = new TomlDocumentImpl(table);
        doc.setOrderMarked(cs.didReadBOM());
        return doc;
    }

    private void write(@NotNull CharTarget ct, @NotNull TomlTable table) throws TomlException {
        TableWriter tw = new TableWriter(ct, this.options);
        tw.writeTable(table);
    }

    @Override
    @NotNull
    public String writeToString(@NotNull TomlTable table) {
        try (StringCharTarget ct = new StringCharTarget();){
            this.write(ct, table);
            String string = ct.toString();
            return string;
        }
    }

    @Override
    public void write(@NotNull OutputStream out, @NotNull TomlTable table) throws TomlIOException {
        WriterCharTarget ct = WriterCharTarget.of(out);
        if (this.shouldWriteBOM(table)) {
            ct.put(65279);
        }
        this.write(ct, table);
        ct.flush();
    }

    @Override
    public void write(@NotNull Writer writer, @NotNull TomlTable table) throws TomlIOException {
        WriterCharTarget ct = new WriterCharTarget(writer);
        if (this.shouldWriteBOM(table)) {
            ct.put(65279);
        }
        this.write(ct, table);
        ct.flush();
    }

    @Override
    @NotNull
    public <T> T serialize(@NotNull Class<T> type, @NotNull TomlTable table) throws IllegalArgumentException {
        int count = 0;
        for (TomlSerializerService service : SERIALIZERS) {
            ++count;
            if (!service.canSerializeTo(type)) continue;
            TomlSerializer<?, T> s = service.getSerializer(this, type);
            return s.serialize(table);
        }
        throw new IllegalArgumentException("No serializer found on classpath for type " + type.getName() + " (checked " + count + " in total)");
    }

    @Override
    @NotNull
    public <T> TomlTable deserialize(@NotNull Class<T> type, @NotNull T data) throws IllegalArgumentException {
        int count = 0;
        for (TomlSerializerService service : SERIALIZERS) {
            ++count;
            if (!service.canDeserializeFrom(type)) continue;
            TomlSerializer<T, ?> d = service.getDeserializer(this, type);
            return d.deserialize(data);
        }
        throw new IllegalArgumentException("No deserializer found on classpath for type " + type.getName() + " (checked " + count + " in total)");
    }

    private boolean shouldWriteBOM(@NotNull TomlTable table) {
        OrderMarkPolicy policy = this.options.get(JTomlOption.WRITE_BOM);
        if (policy == OrderMarkPolicy.NEVER) {
            return false;
        }
        return policy == OrderMarkPolicy.ALWAYS || policy == OrderMarkPolicy.IF_PRESENT && table instanceof TomlDocument && ((TomlDocumentImpl)table).isOrderMarked();
    }

    static {
        ServiceLoader<TomlSerializerService> serializers = ServiceLoader.load(TomlSerializerService.class);
        if (!serializers.iterator().hasNext()) {
            serializers = ServiceLoader.load(TomlSerializerService.class, JToml.class.getClassLoader());
        }
        SERIALIZERS = serializers;
    }
}

