/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.JTomlService;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.document.TomlDocument;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.except.TomlException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.except.TomlIOException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.except.TomlValueException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.option.JTomlOptions;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.table.TomlTable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@ApiStatus.NonExtendable
public interface JToml {
    @Contract(value="_ -> new")
    @NotNull
    public static JToml jToml(@NotNull JTomlOptions options) {
        return JTomlService.get().createInstance(options);
    }

    @Contract(pure=true)
    @NotNull
    public static JToml jToml() {
        return JTomlService.get().defaultInstance();
    }

    @NotNull
    public TomlDocument readFromString(@NotNull String var1) throws TomlException;

    @NotNull
    public TomlDocument read(@NotNull InputStream var1) throws TomlException;

    @ApiStatus.AvailableSince(value="0.3.0")
    @NotNull
    public TomlDocument read(@NotNull Reader var1) throws TomlException;

    @NotNull
    default public TomlDocument read(@NotNull Path file) throws TomlException {
        TomlDocument tomlDocument;
        block8: {
            InputStream is = Files.newInputStream(file, StandardOpenOption.READ);
            try {
                tomlDocument = this.read(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    TomlIOException.rethrow(e);
                    return null;
                }
            }
            is.close();
        }
        return tomlDocument;
    }

    @NotNull
    default public TomlDocument read(@NotNull File file) throws TomlException {
        return this.read(file.toPath());
    }

    @NotNull
    public String writeToString(@NotNull TomlTable var1) throws TomlValueException;

    public void write(@NotNull OutputStream var1, @NotNull TomlTable var2) throws TomlValueException, TomlIOException;

    @ApiStatus.AvailableSince(value="0.3.0")
    public void write(@NotNull Writer var1, @NotNull TomlTable var2) throws TomlValueException, TomlIOException;

    default public void write(@NotNull Path file, @NotNull TomlTable table) throws TomlValueException, TomlIOException {
        try (OutputStream os = Files.newOutputStream(file, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            this.write(os, table);
        }
        catch (IOException e) {
            TomlIOException.rethrow(e);
        }
    }

    default public void write(@NotNull File file, @NotNull TomlTable table) throws TomlValueException, TomlIOException {
        this.write(file.toPath(), table);
    }

    @NotNull
    public <T> T serialize(@NotNull Class<T> var1, @NotNull TomlTable var2) throws IllegalArgumentException;

    @NotNull
    public <T> TomlTable deserialize(@NotNull Class<T> var1, @NotNull T var2) throws IllegalArgumentException;
}

