/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.DeveloperMistakeException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.ErrorContext;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.LoadResult;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.Backend;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.CommentData;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataEntry;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataList;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataTree;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.KebabCaseKeyMapper;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.KeyMapper;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.KeyPath;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.Printable;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.ReadableRoot;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.JToml;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.JTomlServiceImpl;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.comment.CommentPosition;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.comment.Comments;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.document.TomlDocument;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.except.TomlException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.except.TomlIOException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.except.parse.TomlLocalParseException;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.key.TomlKey;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.option.JTomlOption;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.option.JTomlOptions;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.TomlValue;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.array.TomlArray;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.primitive.TomlPrimitive;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.toml.libs.jtoml.value.table.TomlTable;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.CommentLocation;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.internals.lang.LibraryLang;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class TomlBackend
implements Backend {
    private final ReadableRoot dataRoot;
    private final URL syntaxLinter;
    private final JToml jToml;

    public TomlBackend(@NonNull ReadableRoot dataRoot) {
        this.dataRoot = Objects.requireNonNull(dataRoot);
        this.syntaxLinter = TomlBackend.defaultSyntaxLinter();
        JTomlOptions jTomlOptions = JTomlOptions.builder().set(JTomlOption.READ_COMMENTS, false).set(JTomlOption.WRITE_EMPTY_TABLES, true).set(JTomlOption.WRITE_COMMENTS, true).build();
        this.jToml = new JTomlServiceImpl().createInstance(jTomlOptions);
    }

    private static URL defaultSyntaxLinter() {
        try {
            return new URI("https", "toolbox.helpch.at", "/validators/toml", null).toURL();
        }
        catch (MalformedURLException | URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    @Override
    public @NonNull LoadResult<@Nullable Backend.Document> read(@NonNull ErrorContext.Source errorSource) {
        TomlDocument tomlDocument;
        try {
            if (!this.dataRoot.dataExists()) {
                return LoadResult.of(null);
            }
            tomlDocument = this.dataRoot.openReader(this.jToml::read);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        catch (TomlIOException ioEx) {
            throw new UncheckedIOException(ioEx.getCause());
        }
        catch (TomlLocalParseException parseEx) {
            LibraryLang libraryLang = LibraryLang.Accessor.access(errorSource, ErrorContext.Source::getLocale);
            ErrorContext error = errorSource.buildError(Printable.preBuilt(libraryLang.syntax()));
            error.addDetail(ErrorContext.BACKEND_MESSAGE, Printable.preBuilt(parseEx.getMessage()));
            error.addDetail(ErrorContext.SYNTAX_LINTER, this.syntaxLinter);
            error.addDetail(ErrorContext.LINE_NUMBER, parseEx.getLineNumber());
            return LoadResult.failure(error);
        }
        catch (TomlException otherEx) {
            LibraryLang libraryLang = LibraryLang.Accessor.access(errorSource, ErrorContext.Source::getLocale);
            ErrorContext error = errorSource.buildError(Printable.preBuilt(libraryLang.otherReason()));
            error.addDetail(ErrorContext.BACKEND_MESSAGE, Printable.preBuilt(otherEx.getMessage()));
            return LoadResult.failure(error);
        }
        ReadToml readToml = new ReadToml(errorSource);
        final DataTree.Mut data = new DataTree.Mut();
        readToml.readTomlTree(tomlDocument, data);
        if (readToml.error != null) {
            return LoadResult.failure(readToml.error);
        }
        return LoadResult.of(new Backend.Document(){

            @Override
            public @NonNull CommentData comments() {
                return CommentData.empty();
            }

            @Override
            public @NonNull DataTree data() {
                return data;
            }
        });
    }

    @Override
    public void write(@NonNull Backend.Document document) {
        TomlTable tomlTable = this.dataTreeToToml(document.data());
        this.setComments(tomlTable, document.comments());
        try {
            this.dataRoot.openWriter(writer -> {
                this.jToml.write((Writer)writer, tomlTable);
                return null;
            });
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private TomlTable dataTreeToToml(DataTree dataTree) {
        TomlTable tomlTable = TomlTable.create();
        dataTree.forEach((key, entry) -> tomlTable.put(TomlKey.literal((CharSequence[])new String[]{key.toString()}), this.entryToToml((DataEntry)entry)));
        return tomlTable;
    }

    private TomlArray dataListToToml(DataList dataList) {
        TomlArray tomlArray = TomlArray.create(dataList.size());
        dataList.forEach(entry -> tomlArray.add(this.entryToToml((DataEntry)entry)));
        return tomlArray;
    }

    private TomlValue entryToToml(DataEntry entry) {
        TomlValue tomlValue;
        Object value = entry.getValue();
        if (value instanceof DataTree) {
            tomlValue = this.dataTreeToToml((DataTree)value);
        } else if (value instanceof DataList) {
            tomlValue = this.dataListToToml((DataList)value);
        } else if (value instanceof Byte || value instanceof Short || value instanceof Integer) {
            tomlValue = TomlPrimitive.of(((Number)value).intValue());
        } else if (value instanceof Long) {
            tomlValue = TomlPrimitive.of((Long)value);
        } else if (value instanceof Float) {
            tomlValue = TomlPrimitive.of(((Float)value).floatValue());
        } else if (value instanceof Double) {
            tomlValue = TomlPrimitive.of((Double)value);
        } else if (value instanceof Boolean) {
            tomlValue = TomlPrimitive.of((Boolean)value);
        } else if (value instanceof Character) {
            tomlValue = TomlPrimitive.of(((Character)value).toString());
        } else if (value instanceof String) {
            tomlValue = TomlPrimitive.of((String)value);
        } else {
            throw new IllegalStateException("Unknown type in data entry " + value);
        }
        this.setComments(tomlValue, entry.getComments());
        return tomlValue;
    }

    private void setComments(TomlValue tomlValue, CommentData commentData) {
        Comments tomlComments = tomlValue.comments();
        for (CommentPosition tomlPosition : CommentPosition.values()) {
            CommentLocation location = TomlBackend.commentLocationFrom(tomlPosition);
            List<String> commentsHere = commentData.getAt(location);
            if (location == CommentLocation.INLINE && commentsHere.size() > 1) {
                throw new DeveloperMistakeException("Can add at most one inline comment on a toml value");
            }
            for (String commentHere : commentsHere) {
                tomlComments.add(tomlPosition, commentHere);
            }
        }
    }

    private static CommentLocation commentLocationFrom(CommentPosition position) {
        switch (position) {
            case PRE: {
                return CommentLocation.ABOVE;
            }
            case INLINE: {
                return CommentLocation.INLINE;
            }
            case POST: {
                return CommentLocation.BELOW;
            }
        }
        throw new IncompatibleClassChangeError("Unknown " + CommentPosition.class.getSimpleName() + ' ' + (Object)((Object)position));
    }

    @Override
    public @NonNull KeyMapper recommendKeyMapper() {
        return new KebabCaseKeyMapper();
    }

    @Override
    public @NonNull Backend.Meta meta() {
        return new Backend.Meta(){

            @Override
            public boolean supportsComments(boolean documentLevel, boolean reading, @NonNull CommentLocation location) {
                return !reading;
            }

            @Override
            public boolean preservesOrder(boolean reading) {
                return false;
            }

            @Override
            public boolean writesFloatAsDouble() {
                return true;
            }

            @Override
            public boolean allKeysAreStrings() {
                return true;
            }
        };
    }

    private static final class ReadToml {
        private final ArrayDeque<String> keyPathStack = new ArrayDeque();
        private final ErrorContext.Source errorSource;
        private ErrorContext error;

        private ReadToml(ErrorContext.Source errorSource) {
            this.errorSource = errorSource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readTomlTree(TomlTable tomlTable, DataTree.Mut dataTree) {
            for (TomlKey tomlKey : tomlTable.keys(false)) {
                Iterator keyIter = tomlKey.iterator();
                String key = (String)keyIter.next();
                if (keyIter.hasNext()) {
                    throw new IllegalStateException("TomlTable#keys should each have length of 1");
                }
                TomlValue tomlValue = tomlTable.get(tomlKey);
                assert (tomlValue != null);
                this.keyPathStack.addLast(key);
                try {
                    DataEntry dataEntry = this.entryFromToml(tomlValue);
                    if (dataEntry == null) {
                        return;
                    }
                    dataTree.put(key, dataEntry);
                }
                finally {
                    this.keyPathStack.pollLast();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readTomlList(TomlArray tomlArray, DataList.Mut dataList) {
            this.keyPathStack.addLast("$");
            try {
                for (TomlValue tomlElem : tomlArray) {
                    DataEntry dataEntry = this.entryFromToml(tomlElem);
                    if (dataEntry == null) {
                        return;
                    }
                    dataList.add(dataEntry);
                }
            }
            finally {
                this.keyPathStack.pollLast();
            }
        }

        private @Nullable DataEntry entryFromToml(TomlValue tomlValue) {
            Object value;
            if (tomlValue.isTable()) {
                DataTree.Mut dataTree = new DataTree.Mut();
                this.readTomlTree(tomlValue.asTable(), dataTree);
                value = dataTree;
            } else if (tomlValue.isArray()) {
                TomlArray tomlArray = tomlValue.asArray();
                DataList.Mut dataList = new DataList.Mut(tomlArray.size());
                this.readTomlList(tomlArray, dataList);
                value = dataList;
            } else {
                value = tomlValue.asPrimitive().value();
                if (!DataEntry.validateValue(value)) {
                    LibraryLang libraryLang = LibraryLang.Accessor.access(this.errorSource, ErrorContext.Source::getLocale);
                    this.error = this.errorSource.buildError(Printable.preBuilt(libraryLang.tomlDateType()));
                    this.error.addDetail(ErrorContext.ENTRY_PATH, new KeyPath.Immut(this.keyPathStack.toArray(new String[0])));
                }
            }
            if (this.error != null) {
                return null;
            }
            return new DataEntry(value);
        }
    }
}

