/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.it;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.Configuration;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.Backend;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataTree;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.StringRoot;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.it.SampleConfig;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.liaison.SubSection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SampleConfigTest {
    @Test
    public void loadDefaults() {
        Configuration<SampleConfig> configuration = Configuration.defaultBuilder(SampleConfig.class).build();
        SampleConfig defaults = (SampleConfig)configuration.loadDefaults();
        Assertions.assertEquals((Object)"success", (Object)defaults.helloJpms());
        Assertions.assertTrue((boolean)defaults.areWeVisible().shouldBe());
    }

    @Test
    public void writeToBackend() {
        StringRoot stringRoot = new StringRoot("");
        Backend backend = null;
        DataTree.Mut outputTree = new DataTree.Mut();
        Configuration.defaultBuilder(SampleConfig.class).build().writeTo(new SampleConfig(this){

            @Override
            public String helloJpms() {
                return "wrote helloJpms";
            }

            @Override
            public @SubSection SampleConfig.Visible areWeVisible() {
                return () -> true;
            }
        }, outputTree);
        if (backend != null) {
            backend.write(Backend.Document.simple(outputTree));
            Assertions.assertTrue((boolean)stringRoot.readString().contains("wrote helloJpms"));
        }
    }
}

