/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataRoot;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.ReadableRoot;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class StringRoot
implements ReadableRoot {
    private String content;

    public StringRoot(@NonNull String content) {
        this.content = Objects.requireNonNull(content);
    }

    @Override
    public boolean dataExists() throws IOException {
        return true;
    }

    @Override
    public @NonNull String readString() {
        return this.content;
    }

    @Override
    public <R> R openReader(@NonNull DataRoot.Operation<R, @NonNull Reader> operation) throws IOException {
        try (StringReader reader = new StringReader(this.content);){
            R r = operation.operateUsing(reader);
            return r;
        }
    }

    @Override
    public void writeString(@NonNull String content) {
        this.content = Objects.requireNonNull(content);
    }

    @Override
    public <R> R openWriter(@NonNull DataRoot.Operation<R, @NonNull Writer> operation) throws IOException {
        StringWriter writer = new StringWriter();
        R outcome = operation.operateUsing(writer);
        this.content = writer.toString();
        return outcome;
    }
}

