/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.Backend;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.CommentData;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.CountEntries;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataEntry;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataList;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataTree;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.engine.CommentLocation;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.concurrent.ThreadLocalRandom;

record RandomGen(Backend.Meta backendMeta, ThreadLocalRandom random, CountEntries countEntries) {
    private static final int DEPTH_LIMIT = 2;
    private static final int LENGTH_LIMIT = 2;
    private static final char[] alphanumeric = "qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM1234567890".toCharArray();

    void fillDataTree(DataTree.Mut dataTree, int lengthMinimum, int nestDepth) {
        if (nestDepth == 2) {
            return;
        }
        int length = this.random.nextInt(lengthMinimum, 2);
        HashSet<String> seenKeys = this.backendMeta.allKeysAreStrings() ? new HashSet<String>() : null;
        for (int n = 0; n < length; ++n) {
            Object key;
            do {
                key = this.generateRandomValue(true, nestDepth);
            } while (seenKeys != null && !seenKeys.add(key.toString()));
            dataTree.put(key, this.generateRandomEntry(nestDepth));
        }
        this.countEntries.count += length;
    }

    CommentData generateDocumentComments() {
        return this.generateComments(true);
    }

    private DataList generateRandomList(int nestDepth) {
        if (nestDepth == 2) {
            return new DataList.Immut();
        }
        int length = this.random.nextInt(2);
        DataList.Mut entryList = new DataList.Mut(length);
        for (int n = 0; n < length; ++n) {
            entryList.add(this.generateRandomEntry(nestDepth));
        }
        this.countEntries.count += length;
        return entryList;
    }

    private DataEntry generateRandomEntry(int nestDepth) {
        boolean comments;
        DataEntry entry = new DataEntry(this.generateRandomValue(false, nestDepth));
        Object value = entry.getValue();
        boolean bl = comments = !(value instanceof DataTree) && !(value instanceof DataList);
        if (comments && this.random.nextBoolean()) {
            entry = entry.withComments(this.generateComments(false));
        }
        return entry;
    }

    private CommentData generateComments(boolean documentLevel) {
        CommentData commentData = CommentData.empty();
        for (CommentLocation commentLocation : CommentLocation.values()) {
            if (!this.backendMeta.supportsComments(documentLevel, false, commentLocation)) continue;
            int cap = switch (commentLocation) {
                default -> throw new MatchException(null, null);
                case CommentLocation.ABOVE, CommentLocation.BELOW -> 3;
                case CommentLocation.INLINE -> 1;
            };
            String[] comments = new String[cap];
            for (int n = 0; n < cap; ++n) {
                comments[n] = this.randAlphanumericString();
            }
            commentData = commentData.setAt(commentLocation, comments);
        }
        return commentData;
    }

    private Object generateRandomValue(boolean key, int nestDepth) {
        boolean scalar;
        boolean bl = scalar = key || this.random.nextBoolean();
        if (scalar) {
            int switchLimit = !key ? 9 : (this.backendMeta.allKeysAreStrings() ? 7 : 1);
            int type = this.random.nextInt(switchLimit);
            return switch (type) {
                case 0 -> {
                    if (key) {
                        yield this.randAlphanumericString();
                    }
                    yield this.randString();
                }
                case 1 -> this.random.nextBoolean();
                case 2 -> (byte)this.random.nextInt(-128, 128);
                case 3 -> (short)this.random.nextInt(Short.MIN_VALUE, 32768);
                case 4 -> this.random.nextInt();
                case 5 -> this.random.nextLong();
                case 6 -> Character.valueOf((char)this.random.nextInt(0, 65536));
                case 7 -> Float.valueOf(this.random.nextFloat());
                case 8 -> this.random.nextDouble();
                default -> throw new IllegalStateException("Unexpected value: " + type);
            };
        }
        if (this.random.nextBoolean()) {
            return this.generateRandomList(nestDepth + 1);
        }
        DataTree.Mut dataTree = new DataTree.Mut();
        this.fillDataTree(dataTree, 0, nestDepth + 1);
        return dataTree;
    }

    private String randAlphanumericString() {
        int length = 1 + this.random.nextInt(8);
        char[] build = new char[length];
        for (int n = 0; n < length; ++n) {
            build[n] = alphanumeric[this.random.nextInt(alphanumeric.length)];
        }
        return String.valueOf(build);
    }

    private String randString() {
        byte[] data = new byte[this.random.nextInt(32)];
        this.random.nextBytes(data);
        return new String(data, StandardCharsets.UTF_8);
    }
}

