/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend;

import java.io.IOException;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface Printable {
    public @NonNull String printString();

    public void printTo(@NonNull Appendable var1) throws IOException;

    public void printTo(@NonNull StringBuilder var1);

    public @NonNull String toString();

    public static @NonNull Printable preBuilt(final @NonNull CharSequence content) {
        Objects.requireNonNull(content);
        return new Printable(){

            @Override
            public @NonNull String printString() {
                return content.toString();
            }

            @Override
            public void printTo(@NonNull Appendable output) throws IOException {
                output.append(content);
            }

            @Override
            public void printTo(@NonNull StringBuilder output) {
                output.append(content);
            }

            @Override
            public @NonNull String toString() {
                return content.toString();
            }
        };
    }

    public static @NonNull Printable join(final Printable ... values) {
        Objects.requireNonNull(values);
        return new Abstract(){

            @Override
            public void printTo(@NonNull Appendable output) throws IOException {
                for (Printable value : values) {
                    value.printTo(output);
                }
            }
        };
    }

    public static abstract class Abstract
    implements Printable {
        @Override
        public final @NonNull String printString() {
            StringBuilder builder = new StringBuilder();
            this.printTo(builder);
            return builder.toString();
        }

        @Override
        public final void printTo(@NonNull StringBuilder output) {
            try {
                this.printTo((Appendable)output);
            }
            catch (IOException ex) {
                throw new AssertionError("StringBuilder does not throw IOException", ex);
            }
        }

        @Override
        public final @NonNull String toString() {
            return this.printString();
        }
    }
}

