/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.BinaryRoot;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataRoot;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.ReadableRoot;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.internals.ReadWriteIO;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class PathRoot
implements ReadableRoot,
BinaryRoot {
    private final Path path;
    private final Charset charset;

    public PathRoot(@NonNull Path path, @NonNull Charset charset) {
        this.path = Objects.requireNonNull(path, "path");
        this.charset = Objects.requireNonNull(charset, "charset");
    }

    public PathRoot(@NonNull Path path) {
        this(path, StandardCharsets.UTF_8);
    }

    @Override
    public boolean dataExists() throws IOException {
        return Files.exists(this.path, new LinkOption[0]);
    }

    @Override
    public @NonNull String readString() throws IOException {
        return ReadWriteIO.readString(this.path, this.charset);
    }

    @Override
    public <R> R openReader(final @NonNull DataRoot.Operation<R, @NonNull Reader> operation) throws IOException {
        class ReadableByteChannelOperation
        implements DataRoot.Operation<R, ReadableByteChannel> {
            ReadableByteChannelOperation() {
            }

            @Override
            public boolean handlesBuffering() {
                return true;
            }

            @Override
            public R operateUsing(ReadableByteChannel read) throws IOException {
                try (Reader reader = Channels.newReader(read, PathRoot.this.charset.newDecoder(), -1);){
                    Object r;
                    if (operation.handlesBuffering()) {
                        Object r2 = operation.operateUsing(reader);
                        return r2;
                    }
                    try (BufferedReader buffered = new BufferedReader(reader);){
                        r = operation.operateUsing(buffered);
                    }
                    return r;
                }
            }
        }
        return this.openReadChannel(new ReadableByteChannelOperation());
    }

    @Override
    public void writeString(@NonNull String content) throws IOException {
        ReadWriteIO.writeString(this.path, content, this.charset);
    }

    @Override
    public <R> R openWriter(final @NonNull DataRoot.Operation<R, @NonNull Writer> operation) throws IOException {
        class WritableChannelOperation
        implements DataRoot.Operation<R, WritableByteChannel> {
            WritableChannelOperation() {
            }

            @Override
            public boolean handlesBuffering() {
                return true;
            }

            @Override
            public R operateUsing(WritableByteChannel write) throws IOException {
                try (Writer writer = Channels.newWriter(write, PathRoot.this.charset.newEncoder(), -1);){
                    Object r;
                    if (operation.handlesBuffering()) {
                        Object r2 = operation.operateUsing(writer);
                        return r2;
                    }
                    try (BufferedWriter buffered = new BufferedWriter(writer);){
                        r = operation.operateUsing(buffered);
                    }
                    return r;
                }
            }
        }
        return this.openWriteChannel(new WritableChannelOperation());
    }

    @Override
    public <R> R openReadChannel(@NonNull DataRoot.Operation<R, @NonNull ReadableByteChannel> operation) throws IOException {
        try (FileChannel fileChannel = FileChannel.open(this.path, StandardOpenOption.READ);){
            R r = operation.operateUsing(fileChannel);
            return r;
        }
    }

    @Override
    public <R> R openInputStream(@NonNull DataRoot.Operation<R, @NonNull InputStream> operation) throws IOException {
        try (InputStream inputStream = Files.newInputStream(this.path, StandardOpenOption.READ);){
            R r;
            if (operation.handlesBuffering()) {
                R r2 = operation.operateUsing(inputStream);
                return r2;
            }
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);){
                r = operation.operateUsing(bufferedInputStream);
            }
            return r;
        }
    }

    @Override
    public <R> R openWriteChannel(@NonNull DataRoot.Operation<R, @NonNull WritableByteChannel> operation) throws IOException {
        try (FileChannel fileChannel = FileChannel.open(this.path, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            R r = operation.operateUsing(fileChannel);
            return r;
        }
    }

    @Override
    public <R> R openOutputStream(@NonNull DataRoot.Operation<R, @NonNull OutputStream> operation) throws IOException {
        try (OutputStream outputStream = Files.newOutputStream(this.path, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            R r;
            if (operation.handlesBuffering()) {
                R r2 = operation.operateUsing(outputStream);
                return r2;
            }
            try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);){
                r = operation.operateUsing(bufferedOutputStream);
            }
            return r;
        }
    }
}

