/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.BinaryRoot;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataRoot;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.ReadableRoot;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.io.TempDir;

@TestInstance(value=TestInstance.Lifecycle.PER_METHOD)
public abstract class PathBasedRootTest<R extends ReadableRoot & BinaryRoot> {
    private final Path file;
    private final R dataRoot;

    abstract R createRoot(Path var1, Charset var2);

    public PathBasedRootTest(@TempDir Path target) {
        this.file = target.resolve("file.txt");
        this.dataRoot = this.createRoot(this.file, StandardCharsets.ISO_8859_1);
    }

    @Test
    public void dataExists() throws IOException {
        Assertions.assertFalse((boolean)this.dataRoot.dataExists());
        Files.writeString(this.file, (CharSequence)"", StandardCharsets.ISO_8859_1, new OpenOption[0]);
        Assertions.assertTrue((boolean)this.dataRoot.dataExists());
    }

    @Test
    public void readString() throws IOException {
        Files.writeString(this.file, (CharSequence)"content", new OpenOption[0]);
        Assertions.assertEquals((Object)"content", (Object)this.dataRoot.readString());
    }

    @Test
    public void writeString() throws IOException {
        this.dataRoot.writeString("content");
        Assertions.assertEquals((Object)"content", (Object)Files.readString(this.file));
    }

    @Test
    public void readWriteString() throws IOException {
        Files.writeString(this.file, (CharSequence)"", StandardCharsets.ISO_8859_1, new OpenOption[0]);
        Assertions.assertEquals((Object)"", (Object)this.dataRoot.readString());
        this.dataRoot.writeString("content");
        Assertions.assertEquals((Object)"content", (Object)this.dataRoot.readString());
    }

    @Test
    public void openReader() throws IOException {
        Files.writeString(this.file, (CharSequence)"content", new OpenOption[0]);
        Assertions.assertEquals((Object)"content", (Object)this.dataRoot.openReader(reader -> {
            StringWriter output = new StringWriter();
            reader.transferTo(output);
            return output.toString();
        }));
    }

    @Test
    public void openWriter() throws IOException {
        Assertions.assertEquals((int)3, (int)this.dataRoot.openWriter(writer -> {
            writer.write("content");
            return 3;
        }));
        Assertions.assertEquals((Object)"content", (Object)Files.readString(this.file));
    }

    @Test
    public void openReaderHandlesBuffering() throws IOException {
        Files.writeString(this.file, (CharSequence)"content", new OpenOption[0]);
        Assertions.assertEquals((Object)"content", (Object)this.dataRoot.openReader((DataRoot.Operation<String, Reader>)new DataRoot.Operation<String, Reader>(this){

            @Override
            public boolean handlesBuffering() {
                return true;
            }

            @Override
            public String operateUsing(Reader reader) throws IOException {
                StringWriter output = new StringWriter();
                reader.transferTo(output);
                return output.toString();
            }
        }));
    }

    @Test
    public void openWriterHandlesBuffering() throws IOException {
        Assertions.assertEquals((int)3, (int)this.dataRoot.openWriter((DataRoot.Operation<Integer, Writer>)new DataRoot.Operation<Integer, Writer>(this){

            @Override
            public boolean handlesBuffering() {
                return true;
            }

            @Override
            public Integer operateUsing(Writer writer) throws IOException {
                writer.write("content");
                return 3;
            }
        }));
        Assertions.assertEquals((Object)"content", (Object)Files.readString(this.file));
    }

    @Test
    public void openReaderWriter() throws IOException {
        Files.writeString(this.file, (CharSequence)"", StandardCharsets.ISO_8859_1, new OpenOption[0]);
        Assertions.assertEquals((Object)"", (Object)this.dataRoot.openReader(reader -> {
            StringWriter output = new StringWriter();
            reader.transferTo(output);
            return output.toString();
        }));
        Assertions.assertEquals((Object)true, (Object)this.dataRoot.openWriter(writer -> {
            writer.write("content");
            return true;
        }));
        Assertions.assertEquals((Object)"content", (Object)this.dataRoot.openReader(reader -> {
            StringWriter output = new StringWriter();
            reader.transferTo(output);
            return output.toString();
        }));
    }

    @Test
    public void openReadChannel() throws IOException {
        byte[] randomData = new byte[16];
        ThreadLocalRandom.current().nextBytes(randomData);
        Files.write(this.file, randomData, new OpenOption[0]);
        byte[] read = ((BinaryRoot)this.dataRoot).openReadChannel(channel -> {
            ByteBuffer buffer = ByteBuffer.allocate(randomData.length);
            channel.read(buffer);
            return buffer.array();
        });
        Assertions.assertArrayEquals((byte[])randomData, (byte[])read);
    }

    @Test
    public void openInputStream() throws IOException {
        byte[] randomData = new byte[16];
        ThreadLocalRandom.current().nextBytes(randomData);
        Files.write(this.file, randomData, new OpenOption[0]);
        byte[] read = ((BinaryRoot)this.dataRoot).openInputStream(InputStream::readAllBytes);
        Assertions.assertArrayEquals((byte[])randomData, (byte[])read);
    }

    @Test
    public void openWriteChannel() throws IOException {
        byte[] randomData = new byte[16];
        ThreadLocalRandom.current().nextBytes(randomData);
        String success = ((BinaryRoot)this.dataRoot).openWriteChannel(channel -> {
            channel.write(ByteBuffer.wrap(randomData));
            return "success";
        });
        Assertions.assertEquals((Object)"success", (Object)success);
        Assertions.assertArrayEquals((byte[])randomData, (byte[])Files.readAllBytes(this.file));
    }

    @Test
    public void openOutputStream() throws IOException {
        byte[] randomData = new byte[16];
        ThreadLocalRandom.current().nextBytes(randomData);
        String success = ((BinaryRoot)this.dataRoot).openOutputStream(outputStream -> {
            outputStream.write(randomData);
            return "success";
        });
        Assertions.assertEquals((Object)"success", (Object)success);
        Assertions.assertArrayEquals((byte[])randomData, (byte[])Files.readAllBytes(this.file));
    }
}

