/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.Utilities;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DefaultKeyMapper;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.KebabCaseKeyMapper;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.KeyPath;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.KeyPathVerify;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedClass;
import org.junit.jupiter.params.provider.ArgumentsSource;

@ParameterizedClass
@ArgumentsSource(value=KeyPathVerify.Provider.class)
public class KeyPathTest {
    private final KeyPathVerify verify;

    public KeyPathTest(KeyPathVerify verify) {
        this.verify = verify;
    }

    @Test
    public void emptyPath() {
        Assertions.assertEquals((Object)"", (Object)new KeyPath.Mut().toString());
        Assertions.assertArrayEquals((Object[])new String[0], (Object[])new KeyPath.Mut().intoParts());
        Assertions.assertTrue((boolean)new KeyPath.Mut().isEmpty());
        Assertions.assertEquals((int)0, (int)new KeyPath.Mut().size());
    }

    @Test
    public void construct() {
        String target = "my-brave-world.this-feature.enabled";
        Object[] parts = new String[]{"my-brave-world", "this-feature", "enabled"};
        Assertions.assertEquals((Object)target, (Object)new KeyPath.Mut((String[])parts).toString());
        Assertions.assertArrayEquals((Object[])parts, (Object[])new KeyPath.Mut((String[])parts).intoParts());
        Assertions.assertFalse((boolean)new KeyPath.Mut((String[])parts).isEmpty());
        Assertions.assertEquals((int)3, (int)new KeyPath.Mut((String[])parts).size());
    }

    @Test
    public void addFront() {
        KeyPath.Mut keyPath = new KeyPath.Mut();
        keyPath.addFront("enabled");
        keyPath.addFront("this-feature");
        keyPath.addFront("my-brave-world");
        this.verify.assertEq(keyPath, "my-brave-world", "this-feature", "enabled");
    }

    @Test
    public void addBack() {
        KeyPath.Mut keyPath = new KeyPath.Mut();
        keyPath.addBack("my-brave-world");
        keyPath.addBack("this-feature");
        keyPath.addBack("enabled");
        this.verify.assertEq(keyPath, "my-brave-world", "this-feature", "enabled");
    }

    @Test
    public void addFrontKeyMap() {
        KeyPath.Mut keyPath = new KeyPath.Mut();
        keyPath.addFront("thisFeature");
        keyPath.applyKeyMapper(new KebabCaseKeyMapper());
        this.verify.assertEq(keyPath, "this-feature");
    }

    @Test
    public void addFrontKeyMapPostCall() {
        KeyPath.Mut keyPath = new KeyPath.Mut();
        keyPath.applyKeyMapper(new KebabCaseKeyMapper());
        keyPath.addFront("thisFeature");
        this.verify.assertEq(keyPath, "thisFeature");
    }

    @Test
    public void addBackKeyMap() {
        KeyPath.Mut keyPath = new KeyPath.Mut();
        keyPath.addBack("thisFeature");
        keyPath.applyKeyMapper(new KebabCaseKeyMapper());
        this.verify.assertEq(keyPath, "this-feature");
    }

    @Test
    public void addBackKeyMapPostCall() {
        KeyPath.Mut keyPath = new KeyPath.Mut();
        keyPath.applyKeyMapper(new KebabCaseKeyMapper());
        keyPath.addBack("thisFeature");
        this.verify.assertEq(keyPath, "thisFeature");
    }

    @Test
    public void buildVariously1() {
        KeyPath.Mut keyPath = new KeyPath.Mut();
        keyPath.addFront("my-brave-world");
        keyPath.addBack("this-feature");
        keyPath.addBack("enabled");
        keyPath.addFront("section");
        this.verify.assertEq(keyPath, "section", "my-brave-world", "this-feature", "enabled");
    }

    @Test
    public void buildVariously2() {
        KeyPath.Mut keyPath = new KeyPath.Mut();
        keyPath.addBack("my-brave-world");
        keyPath.addBack("this-feature");
        keyPath.addBack("enabled");
        keyPath.addFront("section");
        this.verify.assertEq(keyPath, "section", "my-brave-world", "this-feature", "enabled");
    }

    @Test
    public void buildVariously3() {
        KeyPath.Mut keyPath = new KeyPath.Mut();
        keyPath.addFront("my-brave-world");
        keyPath.addBack("this-feature");
        keyPath.addFront("section");
        keyPath.addBack("enabled");
        this.verify.assertEq(keyPath, "section", "my-brave-world", "this-feature", "enabled");
    }

    @Test
    public void buildVariously4() {
        KeyPath.Mut keyPath = new KeyPath.Mut();
        keyPath.addBack("my-brave-world");
        keyPath.addBack("this-feature");
        keyPath.addFront("section");
        keyPath.addBack("enabled");
        this.verify.assertEq(keyPath, "section", "my-brave-world", "this-feature", "enabled");
    }

    @Test
    public void buildVariously5() {
        KeyPath.Mut keyPath = new KeyPath.Mut();
        keyPath.addFront("my-brave-world");
        keyPath.addBack("this-feature");
        keyPath = keyPath.intoImmut().intoMut();
        keyPath = new KeyPath.Mut(keyPath);
        keyPath.addBack("enabled");
        keyPath.addFront("section");
        this.verify.assertEq(keyPath, "section", "my-brave-world", "this-feature", "enabled");
    }

    @Test
    public void buildVariously6() {
        KeyPath.Mut keyPath = new KeyPath.Mut();
        keyPath.addBack("my-brave-world");
        keyPath.addBack("this-feature");
        keyPath = keyPath.intoImmut().intoMut();
        keyPath = new KeyPath.Mut(keyPath);
        keyPath.addBack("enabled");
        keyPath.addFront("section");
        this.verify.assertEq(keyPath, "section", "my-brave-world", "this-feature", "enabled");
    }

    @Test
    public void buildVariously7() {
        KeyPath.Mut keyPath = new KeyPath.Mut();
        keyPath.addFront("my-brave-world");
        keyPath.addBack("this-feature");
        keyPath = keyPath.intoImmut().intoMut();
        keyPath.addFront("section");
        keyPath.addBack("enabled");
        this.verify.assertEq(keyPath, "section", "my-brave-world", "this-feature", "enabled");
    }

    @Test
    public void buildVariously8() {
        KeyPath.Mut keyPath = new KeyPath.Mut();
        keyPath.addBack("my-brave-world");
        keyPath.addBack("this-feature");
        keyPath = keyPath.intoImmut().intoMut();
        keyPath.addFront("section");
        keyPath.addBack("enabled");
        this.verify.assertEq(keyPath, "section", "my-brave-world", "this-feature", "enabled");
    }

    @Test
    public void buildVariously9() {
        KeyPath.Mut keyPath = new KeyPath.Mut();
        keyPath.applyKeyMapper(new KebabCaseKeyMapper());
        keyPath.addFront("myBraveWorld");
        keyPath.addBack("thisFeature");
        keyPath.addBack("enabled");
        keyPath.addFront("sectionMapped");
        this.verify.assertEq(keyPath, "sectionMapped", "myBraveWorld", "thisFeature", "enabled");
    }

    @Test
    public void buildVariously10() {
        KeyPath.Mut keyPath = new KeyPath.Mut();
        keyPath.applyKeyMapper(new KebabCaseKeyMapper());
        keyPath.addBack("myBraveWorld");
        keyPath.addBack("thisFeature");
        keyPath.addBack("enabled");
        keyPath.addFront("sectionMapped");
        this.verify.assertEq(keyPath, "sectionMapped", "myBraveWorld", "thisFeature", "enabled");
    }

    @Test
    public void buildVariously11() {
        KeyPath.Mut keyPath = new KeyPath.Mut();
        keyPath.applyKeyMapper(new KebabCaseKeyMapper());
        keyPath.addFront("myBraveWorld");
        keyPath.addBack("thisFeature");
        keyPath.addFront("sectionMapped");
        keyPath.addBack("enabled");
        this.verify.assertEq(keyPath, "sectionMapped", "myBraveWorld", "thisFeature", "enabled");
    }

    @Test
    public void buildVariously12() {
        KeyPath.Mut keyPath = new KeyPath.Mut();
        keyPath.applyKeyMapper(new KebabCaseKeyMapper());
        keyPath.addBack("myBraveWorld");
        keyPath.addBack("thisFeature");
        keyPath.addFront("sectionMapped");
        keyPath.addBack("enabled");
        this.verify.assertEq(keyPath, "sectionMapped", "myBraveWorld", "thisFeature", "enabled");
    }

    @Test
    public void buildVariously13() {
        KeyPath.Mut keyPath = new KeyPath.Mut();
        keyPath.applyKeyMapper(new KebabCaseKeyMapper());
        keyPath.addFront("myBraveWorld");
        keyPath.addBack("thisFeature");
        keyPath = keyPath.intoImmut().intoMut();
        keyPath = new KeyPath.Mut(keyPath);
        keyPath.addBack("enabled");
        keyPath.addFront("sectionMapped");
        keyPath.applyKeyMapper(new KebabCaseKeyMapper());
        this.verify.assertEq(keyPath, "section-mapped", "my-brave-world", "this-feature", "enabled");
    }

    @Test
    public void buildVariously14() {
        KeyPath.Mut keyPath = new KeyPath.Mut();
        keyPath.applyKeyMapper(new KebabCaseKeyMapper());
        keyPath.addBack("myBraveWorld");
        keyPath.addBack("thisFeature");
        keyPath = keyPath.intoImmut().intoMut();
        keyPath = new KeyPath.Mut(keyPath);
        keyPath.addBack("enabled");
        keyPath.addFront("sectionMapped");
        keyPath.applyKeyMapper(new KebabCaseKeyMapper());
        this.verify.assertEq(keyPath, "section-mapped", "my-brave-world", "this-feature", "enabled");
    }

    @Test
    public void buildVariously15() {
        KeyPath.Mut keyPath = new KeyPath.Mut();
        keyPath.applyKeyMapper(new KebabCaseKeyMapper());
        keyPath.addFront("myBraveWorld");
        keyPath.addBack("thisFeature");
        keyPath = keyPath.intoImmut().intoMut();
        keyPath = new KeyPath.Mut(keyPath);
        keyPath.addFront("sectionMapped");
        keyPath.addBack("enabled");
        keyPath.applyKeyMapper(new KebabCaseKeyMapper());
        this.verify.assertEq(keyPath, "section-mapped", "my-brave-world", "this-feature", "enabled");
    }

    @Test
    public void buildVariously16() {
        KeyPath.Mut keyPath = new KeyPath.Mut();
        keyPath.applyKeyMapper(new KebabCaseKeyMapper());
        keyPath.addBack("myBraveWorld");
        keyPath.addBack("thisFeature");
        keyPath = keyPath.intoImmut().intoMut();
        keyPath = new KeyPath.Mut(keyPath);
        keyPath.addFront("sectionMapped");
        keyPath.addBack("enabled");
        keyPath.applyKeyMapper(new KebabCaseKeyMapper());
        this.verify.assertEq(keyPath, "section-mapped", "my-brave-world", "this-feature", "enabled");
    }

    @Test
    public void buildVariously17() {
        KeyPath.Mut keyPath = new KeyPath.Mut();
        keyPath.addFront("myBraveWorld");
        keyPath.addBack("thisFeature");
        keyPath.applyKeyMapper(new KebabCaseKeyMapper());
        keyPath = new KeyPath.Mut(keyPath);
        keyPath.addFront("sectionMapped");
        keyPath.addBack("enabled");
        this.verify.assertEq(keyPath, "sectionMapped", "my-brave-world", "this-feature", "enabled");
    }

    @Test
    public void buildVariously18() {
        KeyPath.Mut keyPath = new KeyPath.Mut();
        keyPath.applyKeyMapper(new KebabCaseKeyMapper());
        keyPath.addBack("myBraveWorld");
        keyPath.addBack("thisFeature");
        keyPath.applyKeyMapper(new KebabCaseKeyMapper());
        keyPath = new KeyPath.Mut(keyPath);
        keyPath.addFront("sectionMapped");
        keyPath.addBack("enabled");
        this.verify.assertEq(keyPath, "sectionMapped", "my-brave-world", "this-feature", "enabled");
    }

    @Test
    public void intoMutOnMut() {
        KeyPath.Mut keyPath = new KeyPath.Mut();
        Assertions.assertSame((Object)keyPath, (Object)keyPath.intoMut());
    }

    @Test
    public void intoMutOnImmut() {
        KeyPath.Immut keyPath = new KeyPath.Immut("hi", "there");
        Assertions.assertArrayEquals((Object[])new String[]{"hi", "there"}, (Object[])keyPath.intoMut().intoParts());
    }

    @Test
    public void intoMutOnImmutCannotMutateImmut() {
        KeyPath.Immut original = new KeyPath.Immut("hi", "there");
        KeyPath.Mut mutable = original.intoMut();
        mutable.addFront("start");
        mutable.addBack("bye");
        Assertions.assertArrayEquals((Object[])new String[]{"hi", "there"}, (Object[])original.intoParts());
        Assertions.assertArrayEquals((Object[])new String[]{"start", "hi", "there", "bye"}, (Object[])mutable.intoParts());
    }

    @Test
    public void intoImmutOnImmut() {
        KeyPath.Immut keyPath = new KeyPath.Immut("hi", "there");
        Assertions.assertSame((Object)keyPath, (Object)keyPath.intoImmut());
    }

    @Test
    public void intoImmutOnMut() {
        KeyPath.Mut keyPath = new KeyPath.Mut("hi", "there");
        Assertions.assertArrayEquals((Object[])new String[]{"hi", "there"}, (Object[])keyPath.intoImmut().intoParts());
    }

    @Test
    public void intoImmutOnMutCannotBeMutated() {
        KeyPath.Mut original = new KeyPath.Mut("hi", "there");
        KeyPath.Immut snapshot = original.intoImmut();
        original.addFront("start");
        original.addBack("bye");
        Assertions.assertArrayEquals((Object[])new String[]{"hi", "there"}, (Object[])snapshot.intoParts());
        Assertions.assertArrayEquals((Object[])new String[]{"start", "hi", "there", "bye"}, (Object[])original.intoParts());
    }

    @Test
    public void equality() {
        KeyPath.Mut original = new KeyPath.Mut("bookCalled", "thereThere");
        KeyPath.Mut copy = new KeyPath.Mut(original);
        Assertions.assertEquals((Object)original, (Object)original);
        Assertions.assertEquals((Object)original, (Object)copy);
        Assertions.assertEquals((Object)copy, (Object)original);
        KeyPath.Mut withKeyMapper = new KeyPath.Mut(original);
        original.applyKeyMapper(new DefaultKeyMapper());
        Utilities.assertEqualsBothWays(original, withKeyMapper);
        Utilities.assertEqualsBothWays(new KeyPath.Immut("bookCalled", "thereThere"), withKeyMapper);
    }

    @Test
    public void equalityEmpty() {
        Utilities.assertEqualsBothWays(new KeyPath.Mut(), KeyPath.empty());
        Utilities.assertEqualsBothWays(new KeyPath.Immut(), KeyPath.empty());
        Utilities.assertEqualsBothWays(new KeyPath.Mut(), new KeyPath.Immut());
    }

    @Test
    public void equalityDifferentKeyMapper() {
        KeyPath.Mut original = new KeyPath.Mut("bookCalled", "thereThere");
        KeyPath.Mut twin = new KeyPath.Mut(original);
        KebabCaseKeyMapper keyMapper = new KebabCaseKeyMapper();
        twin.applyKeyMapper(keyMapper);
        Utilities.assertNotEqualsBothWays(original, twin);
        Utilities.assertEqualsBothWays(new KeyPath.Mut("book-called", "there-there"), twin);
        Utilities.assertEqualsBothWays(new KeyPath.Immut("book-called", "there-there"), twin);
        original.applyKeyMapper(keyMapper);
        Utilities.assertEqualsBothWays(original, twin);
        original.addBack("newKey");
        Utilities.assertNotEqualsBothWays(original, twin);
    }

    @AfterEach
    public void sharedEmptyNotModified() throws NoSuchFieldException, IllegalAccessException {
        Field field = KeyPath.class.getDeclaredField("SHARED_EMPTY_PARTS");
        field.setAccessible(true);
        ArrayDeque sharedEmptyParts = (ArrayDeque)field.get(null);
        Assertions.assertTrue((boolean)sharedEmptyParts.isEmpty());
    }
}

