/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.KeyMapper;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.Printable;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public abstract class KeyPath
implements Printable {
    ArrayDeque<CharSequence> parts;
    transient KeyMapper keyMapper;
    private static final ArrayDeque<CharSequence> SHARED_EMPTY_PARTS = new ArrayDeque();

    KeyPath(String ... parts) {
        this.parts = new ArrayDeque<String>(Arrays.asList(parts));
    }

    KeyPath(@NonNull KeyPath other) {
        if (other.keyMapper == null) {
            this.parts = new ArrayDeque<CharSequence>(other.parts);
        } else {
            ArrayDeque parts = new ArrayDeque(other.parts.size());
            other.parts.forEach((? super E part) -> parts.addLast(other.keyMapper.labelToKey((CharSequence)part)));
            this.parts = parts;
        }
    }

    KeyPath(ArrayDeque<CharSequence> parts, KeyMapper keyMapper) {
        this.parts = parts;
        this.keyMapper = keyMapper;
    }

    public static @NonNull KeyPath empty() {
        return new Mut();
    }

    @Pure
    public boolean isEmpty() {
        return this.parts.isEmpty();
    }

    @Pure
    public int size() {
        return this.parts.size();
    }

    public @Nullable CharSequence getLeading(@NonNull SequenceBoundary where) {
        CharSequence edgeValue = where.equals((Object)SequenceBoundary.FRONT) ? this.parts.peekFirst() : this.parts.peekLast();
        if (edgeValue == null) {
            return null;
        }
        String unmapped = edgeValue.toString();
        KeyMapper keyMapper = this.keyMapper;
        return keyMapper == null ? unmapped : keyMapper.labelToKey(unmapped);
    }

    public void iterateFrom(@NonNull SequenceBoundary from, Consumer<? super @NonNull CharSequence> action) {
        CharSequence[] parts = this.intoParts();
        if (from.equals((Object)SequenceBoundary.FRONT)) {
            for (CharSequence part : parts) {
                action.accept(part);
            }
        } else {
            for (int n = parts.length - 1; n >= 0; --n) {
                action.accept(parts[n]);
            }
        }
    }

    @SideEffectFree
    public void forEach(@NonNull Consumer<? super @NonNull CharSequence> action) {
        this.iterateFrom(SequenceBoundary.FRONT, action);
    }

    @SideEffectFree
    public abstract @NonNull Mut intoMut();

    @SideEffectFree
    public abstract @NonNull Immut intoImmut();

    @SideEffectFree
    public @NonNull CharSequence @NonNull [] intoParts() {
        CharSequence[] intoParts = this.parts.toArray(new CharSequence[0]);
        KeyMapper keyMapper = this.keyMapper;
        if (keyMapper != null) {
            for (int n = 0; n < intoParts.length; ++n) {
                intoParts[n] = keyMapper.labelToKey(intoParts[n]);
            }
        }
        return intoParts;
    }

    @SideEffectFree
    public @NonNull List<@NonNull CharSequence> intoPartsList() {
        return Arrays.asList(this.intoParts());
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyPath)) {
            return false;
        }
        KeyPath that = (KeyPath)o;
        if (this.keyMapper == that.keyMapper) {
            return Arrays.equals(this.parts.toArray(), that.parts.toArray());
        }
        if (this.parts.size() != that.parts.size()) {
            return false;
        }
        return Arrays.equals(this.intoParts(), that.intoParts());
    }

    public int hashCode() {
        return Arrays.hashCode(this.intoParts());
    }

    @Override
    public @NonNull String toString() {
        return this.printString();
    }

    @Override
    public @NonNull String printString() {
        StringBuilder builder = new StringBuilder();
        this.printTo(builder);
        return builder.toString();
    }

    @Override
    public void printTo(@NonNull Appendable output) throws IOException {
        CharSequence[] parts = this.parts.toArray(new CharSequence[0]);
        KeyMapper keyMapper = this.keyMapper;
        for (int n = 0; n < parts.length; ++n) {
            if (n != 0) {
                output.append('.');
            }
            output.append(keyMapper == null ? parts[n] : keyMapper.labelToKey(parts[n]));
        }
    }

    @Override
    public void printTo(@NonNull StringBuilder output) {
        try {
            this.printTo((Appendable)output);
        }
        catch (IOException ex) {
            throw new AssertionError("StringBuilder does not throw IOException", ex);
        }
    }

    public static final class Mut
    extends KeyPath {
        private boolean dataFrozen;

        public Mut() {
            super(SHARED_EMPTY_PARTS, null);
            this.dataFrozen = true;
        }

        public Mut(String ... parts) {
            super(parts);
        }

        public Mut(@NonNull KeyPath other) {
            super(other);
        }

        Mut(ArrayDeque<CharSequence> parts, KeyMapper keyMapper) {
            super(parts, keyMapper);
        }

        @Override
        public @NonNull Mut intoMut() {
            return this;
        }

        @Override
        public @NonNull Immut intoImmut() {
            this.dataFrozen = true;
            return new Immut(this.parts, this.keyMapper);
        }

        private void flushKeyMapper() {
            KeyMapper keyMapper = this.keyMapper;
            if (keyMapper != null) {
                if (!this.parts.isEmpty()) {
                    ArrayDeque<CharSequence> mappedParts = new ArrayDeque<CharSequence>(this.parts.size() + 8);
                    for (CharSequence part : this.parts) {
                        mappedParts.add(keyMapper.labelToKey(part));
                    }
                    this.parts = mappedParts;
                    this.dataFrozen = false;
                }
                this.keyMapper = null;
            }
        }

        private void ensureMutable() {
            this.flushKeyMapper();
            if (this.dataFrozen) {
                this.parts = this.parts.isEmpty() ? new ArrayDeque() : new ArrayDeque(this.parts);
                this.dataFrozen = false;
            }
        }

        public void applyKeyMapper(@NonNull KeyMapper keyMapper) {
            this.flushKeyMapper();
            this.keyMapper = Objects.requireNonNull(keyMapper);
        }

        public void addFront(@NonNull CharSequence part) {
            this.ensureMutable();
            this.parts.addFirst(part);
        }

        public void addBack(@NonNull CharSequence part) {
            this.ensureMutable();
            this.parts.addLast(part);
        }

        public void addPath(@NonNull SequenceBoundary boundary, @NonNull KeyPath toAdd) {
            if (toAdd.isEmpty()) {
                return;
            }
            this.ensureMutable();
            SequenceBoundary sourceStartFrom = boundary.opposite();
            toAdd.iterateFrom(sourceStartFrom, boundary == SequenceBoundary.FRONT ? this.parts::addFirst : this.parts::addLast);
        }
    }

    public static enum SequenceBoundary {
        FRONT,
        BACK;


        public @NonNull SequenceBoundary opposite() {
            return this == FRONT ? BACK : FRONT;
        }
    }

    public static final class Immut
    extends KeyPath {
        public Immut() {
            super(SHARED_EMPTY_PARTS, null);
        }

        public Immut(String ... parts) {
            super(parts);
        }

        public Immut(@NonNull KeyPath other) {
            super(other);
        }

        Immut(ArrayDeque<CharSequence> parts, KeyMapper keyMapper) {
            super(parts, keyMapper);
        }

        @Override
        public @NonNull Mut intoMut() {
            Mut mutCopy = new Mut(this.parts, this.keyMapper);
            mutCopy.dataFrozen = true;
            return mutCopy;
        }

        @Override
        public @NonNull Immut intoImmut() {
            return this;
        }
    }
}

