/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend;

import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.DataRoot;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.InputOutputRoot;
import fi.fabianadrian.nightaccelerator.dependency.space.arim.dazzleconf.backend.PathBasedRootTest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.io.TempDir;

@TestInstance(value=TestInstance.Lifecycle.PER_METHOD)
public class InputOutputRootTest
extends PathBasedRootTest<InputOutputRoot> {
    public InputOutputRootTest(@TempDir Path target) {
        super(target);
    }

    @Override
    InputOutputRoot createRoot(final Path file, Charset charset) {
        return new InputOutputRoot(this, charset){

            @Override
            public <R> R openInputStream(@NonNull DataRoot.Operation<R, @NonNull InputStream> operation) throws IOException {
                try (InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);){
                    R r = operation.operateUsing(inputStream);
                    return r;
                }
            }

            @Override
            public <R> R openOutputStream(@NonNull DataRoot.Operation<R, @NonNull OutputStream> operation) throws IOException {
                try (OutputStream outputStream = Files.newOutputStream(file, new OpenOption[0]);){
                    R r = operation.operateUsing(outputStream);
                    return r;
                }
            }

            @Override
            public boolean dataExists() throws IOException {
                return Files.exists(file, new LinkOption[0]);
            }
        };
    }
}

